
zhtml.Text = zk.$extends(zhtml.Widget, {
	_value: '',
	_encode: true,

	$define: {
		
		
		encode: _zkf = function () {
			var n = this.$n();
			if (n) {
				var val = this._value;
				n.innerHTML = this._encode ? zUtl.encodeXML(val): val;
				
			}
		},
		
		
		value: _zkf
	},
	
	
	_checkContentRequired: function (val) {
		if (val) {
			val = val.trim();
			if (val && !(val.startsWith('<\!--') && val.endsWith('-->')))
				return true;
		}
		return false;
	},
	redraw: function (out) {
		var attrs = this.domAttrs_({id:1, zclass:1}),
			val = this._value,
			span = attrs || (this.idRequired && this._checkContentRequired(val));
			
		if (span) out.push('<span', ' id="', this.uuid, '"', attrs, '>');
		out.push(this._encode ? zUtl.encodeXML(val): val);
			
		if (span) out.push('</span>');
	}
});
