/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.SystemException;

public class Fields {
    public static final void setAccessible(AccessibleObject f, boolean accessible) {
        try {
            f.setAccessible(accessible);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final Object getByCompound(Object obj, String name) throws NoSuchMethodException {
        int j;
        while ((j = name.indexOf(46)) >= 0) {
            if ((obj = Fields.get(obj, name.substring(0, j))) == null) {
                return obj;
            }
            name = name.substring(j + 1);
        }
        return Fields.get(obj, name);
    }

    public static final void setByCompound(Object obj, String name, Object val, boolean autoCoerce) throws NoSuchMethodException {
        while (true) {
            int j;
            if ((j = name.indexOf(46)) < 0) {
                Fields.set(obj, name, val, autoCoerce);
                return;
            }
            obj = Fields.get(obj, name.substring(0, j));
            name = name.substring(j + 1);
        }
    }

    public static final void setByCompound(Object obj, String name, Object val) throws NoSuchMethodException {
        Fields.setByCompound(obj, name, val, false);
    }

    public static final Object get(Object obj, String name) throws NoSuchMethodException {
        try {
            AccessibleObject acs = Classes.getAccessibleObject(obj.getClass(), name, null, 2);
            return acs instanceof Method ? ((Method)acs).invoke(obj, new Object[0]) : ((Field)acs).get(obj);
        }
        catch (NoSuchMethodException ex) {
            if (obj instanceof Map) {
                return ((Map)obj).get(name);
            }
            throw ex;
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap((Throwable)ex, "Not found: " + name);
        }
    }

    public static final void set(Object obj, String name, Object val, boolean autoCoerce) throws NoSuchMethodException {
        try {
            AccessibleObject acs;
            try {
                acs = Classes.getAccessibleObject(obj.getClass(), name, new Class[]{val != null ? val.getClass() : null}, 3);
            }
            catch (NoSuchMethodException ex) {
                if (!autoCoerce || val == null) {
                    throw ex;
                }
                acs = Classes.getAccessibleObject(obj.getClass(), name, new Class[]{null}, 3);
            }
            if (acs instanceof Method) {
                Method mtd = (Method)acs;
                mtd.invoke(obj, autoCoerce ? Classes.coerce(mtd.getParameterTypes()[0], val) : val);
            } else {
                Field fld = (Field)acs;
                fld.set(obj, autoCoerce ? Classes.coerce(fld.getType(), val) : val);
            }
        }
        catch (NoSuchMethodException ex) {
            if (obj instanceof Map) {
                ((Map)obj).put(name, val);
                return;
            }
            throw ex;
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap((Throwable)ex, "Not found: " + name);
        }
    }
}

