/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.html;

import org.zkoss.lang.Objects;

public class JavaScript {
    private final String _src;
    private final String _charset;
    private final String _content;

    public JavaScript(String src, String charset) {
        if (src == null) {
            throw new IllegalArgumentException("null src");
        }
        if (charset == null || charset.length() == 0) {
            charset = "UTF-8";
        }
        this._src = src;
        this._charset = charset;
        this._content = null;
    }

    public JavaScript(String content) {
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        this._charset = null;
        this._src = null;
        this._content = content;
    }

    public String getSrc() {
        return this._src;
    }

    public String getCharset() {
        return this._charset;
    }

    public String getContent() {
        return this._content;
    }

    public String toString() {
        return "[src: " + this._src + " charset=" + this._charset + ']';
    }

    public int hashCode() {
        return Objects.hashCode(this._src) + Objects.hashCode(this._content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaScript)) {
            return false;
        }
        JavaScript js = (JavaScript)o;
        return Objects.equals(js._src, this._src) && Objects.equals(js._charset, this._charset) && Objects.equals(js._content, this._content);
    }
}

