/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.zkoss.util.Cleanups;
import org.zkoss.util.ScalableTimerInfo;
import org.zkoss.util.ScalableTimerTask;
import org.zkoss.util.logging.Log;

public class ScalableTimer {
    private static final Log log = Log.lookup(ScalableTimer.class);
    private final ScalableTimerInfo[] _tis;
    private int _threshold;

    public ScalableTimer(int cTimers, int threshold) {
        if (cTimers <= 0) {
            cTimers = 1;
        }
        if (threshold <= 0) {
            threshold = 1;
        }
        this._tis = new ScalableTimerInfo[cTimers];
        int j = cTimers;
        while (--j >= 0) {
            this._tis[j] = new ScalableTimerInfo();
        }
        this._threshold = threshold;
        Cleanups.add(new Cleanups.Cleanup(){

            public void cleanup() {
                ScalableTimer.this.cancel();
            }
        });
    }

    public int getMaxTimerSize() {
        return this._tis.length;
    }

    public int getThreshold() {
        return this._threshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        int j = this._tis.length;
        while (--j >= 0) {
            ScalableTimerInfo ti;
            ScalableTimerInfo scalableTimerInfo = ti = this._tis[j];
            synchronized (scalableTimerInfo) {
                if (ti.timer != null) {
                    try {
                        ti.timer.cancel();
                    }
                    catch (Throwable ex) {
                        log.warningBriefly("Unable to cancel " + ti.timer, ex);
                    }
                    ti.timer = null;
                }
                ti.count = 0;
            }
        }
    }

    public void schedule(ScalableTimerTask task, long delay) {
        this.getInfo((ScalableTimerTask)task).timer.schedule((TimerTask)task, delay);
    }

    public void schedule(ScalableTimerTask task, Date time) {
        this.getInfo((ScalableTimerTask)task).timer.schedule((TimerTask)task, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScalableTimerInfo getInfo(ScalableTimerTask task) {
        ScalableTimerInfo ti = null;
        int j = this._tis.length;
        while (--j >= 0) {
            if (this._tis[j].count < this._threshold) {
                ti = this._tis[j];
                break;
            }
            if (ti != null && ti.count <= this._tis[j].count) continue;
            ti = this._tis[j];
        }
        ScalableTimerInfo scalableTimerInfo = ti;
        synchronized (scalableTimerInfo) {
            ++ti.count;
            if (ti.timer == null) {
                ti.timer = new Timer(true);
            }
        }
        task.setScalableTimerInfo(ti);
        return ti;
    }
}

