/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.idom.Verifier;
import org.zkoss.idom.impl.AbstractItem;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.lang.SystemException;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.Maps;

public class ProcessingInstruction
extends AbstractItem
implements org.w3c.dom.ProcessingInstruction {
    protected String _target;
    protected String _rawData;

    public ProcessingInstruction(String target, String data) {
        this.setTarget(target);
        this.setData(data);
    }

    public ProcessingInstruction(String target, Map data) {
        this.setTarget(target);
        this.setData(data);
    }

    protected ProcessingInstruction() {
    }

    public final String getTarget() {
        return this._target;
    }

    public final void setTarget(String target) {
        if (!Objects.equals(this._target, target)) {
            Verifier.checkPITarget(target, this.getLocator());
            this._target = target;
        }
    }

    public final String getData() {
        return this._rawData;
    }

    public final void setData(String data) {
        if (data == null) {
            data = "";
        }
        this._rawData = data;
    }

    public final Map parseData() {
        return ProcessingInstruction.parseToMap(new LinkedHashMap(), this.getData());
    }

    public final void setData(Map data) {
        String notAllowed = "= '\"";
        Iterator it = data.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            int j = Strings.anyOf(key, "= '\"", 0);
            if (j >= key.length()) continue;
            char cc = key.charAt(j);
            throw new SystemException(MCommon.ILLEGAL_CHAR, cc + " (0x" + Integer.toHexString(cc) + ')');
        }
        this.setData(Maps.toString(data, '\"', ' '));
    }

    public static final Map parseToMap(Map map, String rawData) {
        if (rawData == null || rawData.trim().length() == 0) {
            return map != null ? map : Collections.EMPTY_MAP;
        }
        map = Maps.parse(map, rawData, ' ', '\u0001');
        Iterator it = map.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry me = it.next();
            String val = (String)me.getValue();
            StringBuffer sb = null;
            int i = 0;
            int j = 0;
            int len = val.length();
            while (true) {
                int k;
                if ((k = val.indexOf(38, j)) < 0) {
                    if (sb == null) continue block0;
                    me.setValue(sb.append(val.substring(i)).toString());
                    continue block0;
                }
                int l = val.indexOf(59, k);
                if (l >= 0) {
                    int cc;
                    String code = val.substring(k + 1, l);
                    if ("quot".equals(code)) {
                        cc = 34;
                    } else if ("amp".equals(code)) {
                        cc = 38;
                    } else if ("lt".equals(code)) {
                        cc = 60;
                    } else if ("gt".equals(code)) {
                        cc = 62;
                    } else {
                        j = l + 1;
                        continue;
                    }
                    if (sb == null) {
                        sb = new StringBuffer(len);
                    }
                    sb.append(val.substring(i, k)).append((char)cc);
                    i = j = l + 1;
                    continue;
                }
                j = k + 1;
            }
        }
        return map;
    }

    public final String getName() {
        return this.getTarget();
    }

    public final void setName(String name) {
        this.setTarget(name);
    }

    public final String getText() {
        return this.getData();
    }

    public final void setText(String text) {
        this.setData(text);
    }

    public final short getNodeType() {
        return 7;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64).append("[PI: ").append(this._target);
        if (this._rawData.length() > 0) {
            sb.append(' ').append(this._rawData);
        }
        return sb.append(']').toString();
    }
}

