/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public class Websocket {
    private final ClientApi api;

    public Websocket(ClientApi api) {
        this.api = api;
    }

    public ApiResponse channels() throws ClientApiException {
        return this.api.callApi("websocket", "view", "channels", null);
    }

    public ApiResponse message(String channelid, String messageid) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelId", channelid);
        map.put("messageId", messageid);
        return this.api.callApi("websocket", "view", "message", map);
    }

    public ApiResponse messages(String channelid, String start, String count, String payloadpreviewlength) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (channelid != null) {
            map.put("channelId", channelid);
        }
        if (start != null) {
            map.put("start", start);
        }
        if (count != null) {
            map.put("count", count);
        }
        if (payloadpreviewlength != null) {
            map.put("payloadPreviewLength", payloadpreviewlength);
        }
        return this.api.callApi("websocket", "view", "messages", map);
    }

    public ApiResponse breakTextMessage() throws ClientApiException {
        return this.api.callApi("websocket", "view", "breakTextMessage", null);
    }

    public ApiResponse sendTextMessage(String channelid, String outgoing, String message) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelId", channelid);
        map.put("outgoing", outgoing);
        map.put("message", message);
        return this.api.callApi("websocket", "action", "sendTextMessage", map);
    }

    public ApiResponse setBreakTextMessage(String message, String outgoing) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("message", message);
        map.put("outgoing", outgoing);
        return this.api.callApi("websocket", "action", "setBreakTextMessage", map);
    }
}

