/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.clientapi.gen;

import java.nio.charset.Charset;
import java.util.HashMap;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;
import org.zaproxy.clientapi.gen.deprecated.ScriptDeprecated;

public class Script
extends ScriptDeprecated {
    private final ClientApi api;

    public Script(ClientApi api) {
        super(api);
        this.api = api;
    }

    public ApiResponse listEngines() throws ClientApiException {
        return this.api.callApi("script", "view", "listEngines", null);
    }

    public ApiResponse listTypes() throws ClientApiException {
        return this.api.callApi("script", "view", "listTypes", null);
    }

    public ApiResponse listScripts() throws ClientApiException {
        return this.api.callApi("script", "view", "listScripts", null);
    }

    public ApiResponse globalVar(String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("varKey", varkey);
        return this.api.callApi("script", "view", "globalVar", map);
    }

    public ApiResponse globalCustomVar(String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("varKey", varkey);
        return this.api.callApi("script", "view", "globalCustomVar", map);
    }

    public ApiResponse globalVars() throws ClientApiException {
        return this.api.callApi("script", "view", "globalVars", null);
    }

    public ApiResponse globalCustomVars() throws ClientApiException {
        return this.api.callApi("script", "view", "globalCustomVars", null);
    }

    public ApiResponse scriptVar(String scriptname, String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        map.put("varKey", varkey);
        return this.api.callApi("script", "view", "scriptVar", map);
    }

    public ApiResponse scriptCustomVar(String scriptname, String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        map.put("varKey", varkey);
        return this.api.callApi("script", "view", "scriptCustomVar", map);
    }

    public ApiResponse scriptVars(String scriptname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        return this.api.callApi("script", "view", "scriptVars", map);
    }

    public ApiResponse scriptCustomVars(String scriptname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        return this.api.callApi("script", "view", "scriptCustomVars", map);
    }

    public ApiResponse enable(String scriptname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        return this.api.callApi("script", "action", "enable", map);
    }

    public ApiResponse disable(String scriptname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        return this.api.callApi("script", "action", "disable", map);
    }

    public ApiResponse load(String scriptname, String scripttype, String scriptengine, String filename, String scriptdescription, Charset charset) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        map.put("scriptType", scripttype);
        map.put("scriptEngine", scriptengine);
        map.put("fileName", filename);
        if (scriptdescription != null) {
            map.put("scriptDescription", scriptdescription);
        }
        if (charset != null) {
            map.put("charset", charset.name());
        }
        return this.api.callApi("script", "action", "load", map);
    }

    public ApiResponse remove(String scriptname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        return this.api.callApi("script", "action", "remove", map);
    }

    public ApiResponse runStandAloneScript(String scriptname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        return this.api.callApi("script", "action", "runStandAloneScript", map);
    }

    public ApiResponse clearGlobalVar(String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("varKey", varkey);
        return this.api.callApi("script", "action", "clearGlobalVar", map);
    }

    public ApiResponse clearGlobalCustomVar(String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("varKey", varkey);
        return this.api.callApi("script", "action", "clearGlobalCustomVar", map);
    }

    public ApiResponse clearGlobalVars() throws ClientApiException {
        return this.api.callApi("script", "action", "clearGlobalVars", null);
    }

    public ApiResponse clearScriptVar(String scriptname, String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        map.put("varKey", varkey);
        return this.api.callApi("script", "action", "clearScriptVar", map);
    }

    public ApiResponse clearScriptCustomVar(String scriptname, String varkey) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        map.put("varKey", varkey);
        return this.api.callApi("script", "action", "clearScriptCustomVar", map);
    }

    public ApiResponse clearScriptVars(String scriptname) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        return this.api.callApi("script", "action", "clearScriptVars", map);
    }

    public ApiResponse setScriptVar(String scriptname, String varkey, String varvalue) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("scriptName", scriptname);
        map.put("varKey", varkey);
        if (varvalue != null) {
            map.put("varValue", varvalue);
        }
        return this.api.callApi("script", "action", "setScriptVar", map);
    }

    public ApiResponse setGlobalVar(String varkey, String varvalue) throws ClientApiException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("varKey", varkey);
        if (varvalue != null) {
            map.put("varValue", varvalue);
        }
        return this.api.callApi("script", "action", "setGlobalVar", map);
    }
}

