/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class FSImageWriter {
    public static final String DEFAULT_IMAGE_FORMAT = "png";
    private final String imageFormat;
    private float writeCompressionQuality;
    private int writeCompressionMode;
    private String writeCompressionType;

    public FSImageWriter() {
        this(DEFAULT_IMAGE_FORMAT);
    }

    public FSImageWriter(String imageFormat) {
        this.imageFormat = imageFormat;
        this.writeCompressionMode = 3;
        this.writeCompressionType = null;
        this.writeCompressionQuality = 1.0f;
    }

    public static FSImageWriter newJpegWriter(float quality) {
        FSImageWriter writer = new FSImageWriter("jpg");
        writer.setWriteCompressionMode(2);
        writer.setWriteCompressionType("JPEG");
        writer.setWriteCompressionQuality(quality);
        return writer;
    }

    public void write(BufferedImage image, String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            if (!file.delete()) {
                throw new IOException("File " + filePath + " exists already, and call to .delete() failed unexpectedly");
            }
        } else if (!file.createNewFile()) {
            throw new IOException("Unable to create file at path " + filePath + ", call to .createNewFile() failed unexpectedly.");
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            this.write(image, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BufferedImage image, OutputStream os) throws IOException {
        ImageWriter writer = this.lookupImageWriterForFormat(this.imageFormat);
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(os);){
            writer.setOutput(ios);
            ImageWriteParam parameters = this.getImageWriteParameters(writer);
            writer.write(null, new IIOImage(image, null, null), parameters);
            ios.flush();
        }
        finally {
            writer.dispose();
        }
    }

    protected ImageWriteParam getImageWriteParameters(ImageWriter writer) {
        ImageWriteParam param = writer.getDefaultWriteParam();
        if (param.canWriteCompressed() && this.writeCompressionMode != 3) {
            param.setCompressionMode(this.writeCompressionMode);
            if (this.writeCompressionMode == 2) {
                param.setCompressionType(this.writeCompressionType);
                param.setCompressionQuality(this.writeCompressionQuality);
            }
        }
        return param;
    }

    public void setWriteCompressionQuality(float q) {
        this.writeCompressionQuality = q;
    }

    public void setWriteCompressionMode(int mode) {
        this.writeCompressionMode = mode;
    }

    public void setWriteCompressionType(String type) {
        this.writeCompressionType = type;
    }

    @Nonnull
    private ImageWriter lookupImageWriterForFormat(String imageFormat) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(imageFormat);
        if (iter.hasNext()) {
            return iter.next();
        }
        throw new IllegalArgumentException("Image writer not found for format " + imageFormat);
    }
}

