/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import java.awt.Color;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicButtonUI;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.style.derived.LengthValue;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.InputField;

abstract class AbstractButtonField<T extends JButton>
extends InputField<JButton> {
    protected AbstractButtonField(Element e, XhtmlForm form, LayoutContext context, BlockBox box) {
        super(e, form, context, box);
    }

    protected void applyComponentStyle(T button) {
        FSDerivedValue heightValue;
        super.applyComponentStyle((JComponent)button);
        CalculatedStyle style = this.getBox().getStyle();
        FSColor backgroundColor = style.getBackgroundColor();
        if (style.disableOSBorder() || backgroundColor instanceof FSRGBColor) {
            BasicButtonUI ui = new BasicButtonUI();
            ((AbstractButton)button).setUI(ui);
            if (backgroundColor instanceof FSRGBColor) {
                FSRGBColor rgb = (FSRGBColor)backgroundColor;
                ((JComponent)button).setBackground(new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
            }
            if (style.disableOSBorder()) {
                ((JComponent)button).setBorder(new BasicBorders.MarginBorder());
            } else {
                ((JComponent)button).setBorder(BasicBorders.getButtonBorder());
            }
        }
        ((AbstractButton)button).setMargin(style.padding().withDefaults(new Insets(2, 12, 2, 12)));
        RectPropertySet padding = style.getCachedPadding();
        padding.reset();
        FSDerivedValue widthValue = style.valueByName(CSSName.WIDTH);
        if (widthValue instanceof LengthValue) {
            this.intrinsicWidth = this.getBox().getContentWidth();
        }
        if ((heightValue = style.valueByName(CSSName.HEIGHT)) instanceof LengthValue) {
            this.intrinsicHeight = this.getBox().getHeight();
        }
    }
}

