/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.css.constants;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.xhtmlrenderer.util.GeneralUtil;
import org.xhtmlrenderer.util.XRLog;

public final class ValueConstants {
    private static final Map<Short, String> sacTypesStrings = new HashMap<Short, String>(25);

    public static String stringForSACPrimitiveType(short type) {
        return sacTypesStrings.get(type);
    }

    public static boolean isAbsoluteUnit(short type) {
        return switch (type) {
            case 2 -> false;
            case 3, 4 -> true;
            case 5, 6, 7, 8, 9, 10 -> true;
            case 25 -> true;
            case 1, 18, 22, 24 -> true;
            case 23 -> true;
            case 11, 12, 13 -> true;
            case 16, 17 -> true;
            case 14, 15 -> true;
            case 19, 20, 21 -> true;
            case 0 -> {
                XRLog.cascade(Level.WARNING, "Asked whether type was absolute, given CSS_UNKNOWN as the type. Might be one of those funny values like background-position.");
                GeneralUtil.dumpShortException(new Exception("Taking a thread dump..."));
                yield false;
            }
            default -> false;
        };
    }

    public static boolean isNumber(short cssPrimitiveType) {
        return switch (cssPrimitiveType) {
            case 2, 3, 4 -> false;
            case 5, 6, 7, 8, 9, 10 -> true;
            default -> false;
        };
    }

    static {
        sacTypesStrings.put((short)3, "em");
        sacTypesStrings.put((short)4, "ex");
        sacTypesStrings.put((short)5, "px");
        sacTypesStrings.put((short)2, "%");
        sacTypesStrings.put((short)8, "in");
        sacTypesStrings.put((short)6, "cm");
        sacTypesStrings.put((short)7, "mm");
        sacTypesStrings.put((short)9, "pt");
        sacTypesStrings.put((short)10, "pc");
    }
}

