/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.webservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.wso2.carbon.analytics.dataservice.commons.AggregateField;
import org.wso2.carbon.analytics.dataservice.commons.AggregateRequest;
import org.wso2.carbon.analytics.dataservice.commons.SearchResultEntry;
import org.wso2.carbon.analytics.dataservice.commons.SortByField;
import org.wso2.carbon.analytics.dataservice.commons.SortType;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinition;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinitionExt;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.webservice.beans.AggregateResponse;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsAggregateField;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsAggregateRequest;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsCategoryPathBean;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsSchemaBean;
import org.wso2.carbon.analytics.webservice.beans.EventBean;
import org.wso2.carbon.analytics.webservice.beans.RecordBean;
import org.wso2.carbon.analytics.webservice.beans.RecordValueEntryBean;
import org.wso2.carbon.analytics.webservice.beans.SchemaColumnBean;
import org.wso2.carbon.analytics.webservice.beans.SortByFieldBean;
import org.wso2.carbon.analytics.webservice.beans.StreamDefAttributeBean;
import org.wso2.carbon.analytics.webservice.beans.StreamDefinitionBean;
import org.wso2.carbon.analytics.webservice.beans.ValuesBatchBean;
import org.wso2.carbon.analytics.webservice.exception.AnalyticsWebServiceException;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;

public class Utils {
    public static final String EMPTY_VALUE = "";

    private Utils() {
    }

    public static List<RecordBean> createRecordBeans(List<Record> records) {
        ArrayList<RecordBean> recordBeans = new ArrayList<RecordBean>();
        if (records != null) {
            for (Record record : records) {
                RecordBean recordBean = Utils.createRecordBean(record);
                recordBeans.add(recordBean);
            }
        }
        return recordBeans;
    }

    public static Map<String, RecordBean> createRecordBeansKeyedWithIds(RecordBean[] records) {
        HashMap<String, RecordBean> recordBeans = new HashMap<String, RecordBean>();
        if (records != null) {
            for (RecordBean record : records) {
                recordBeans.put(record.getId(), record);
            }
        }
        return recordBeans;
    }

    public static RecordBean createRecordBean(Record record) {
        RecordBean recordBean = new RecordBean();
        recordBean.setId(record.getId());
        recordBean.setTableName(record.getTableName());
        recordBean.setTimestamp(record.getTimestamp());
        if (record.getValues() != null) {
            recordBean.setValues(Utils.createRecordEntryBeans(record.getValues()));
        }
        return recordBean;
    }

    private static RecordValueEntryBean[] createRecordEntryBeans(Map<String, Object> values) {
        ArrayList<RecordValueEntryBean> beans = new ArrayList<RecordValueEntryBean>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            RecordValueEntryBean bean = new RecordValueEntryBean();
            if (entry.getValue() instanceof List) {
                List analyticsCategoryPath = (List)entry.getValue();
                Iterator iterator = analyticsCategoryPath.iterator();
                ArrayList<String> pathAsString = new ArrayList<String>();
                while (iterator.hasNext()) {
                    pathAsString.add(String.valueOf(iterator.next()));
                }
                AnalyticsCategoryPathBean categoryPathBean = new AnalyticsCategoryPathBean();
                categoryPathBean.setPath(pathAsString.toArray(new String[pathAsString.size()]));
                bean.setFieldName(entry.getKey());
                bean.setAnalyticsCategoryPathBeanValue(categoryPathBean);
                bean.setType("FACET");
                beans.add(bean);
                continue;
            }
            beans.add(Utils.getRecordValueEntryBean(entry.getKey(), entry.getValue()));
        }
        return beans.toArray(new RecordValueEntryBean[beans.size()]);
    }

    public static String[] getRecordIds(List<SearchResultEntry> searchResults) {
        ArrayList<String> ids = new ArrayList<String>();
        if (searchResults != null) {
            for (SearchResultEntry searchResult : searchResults) {
                ids.add(searchResult.getId());
            }
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static AnalyticsSchemaBean createTableSchemaBean(AnalyticsSchema analyticsSchema) {
        if (analyticsSchema == null) {
            return null;
        }
        ArrayList<SchemaColumnBean> columnBeans = new ArrayList<SchemaColumnBean>();
        if (analyticsSchema.getColumns() != null) {
            for (Map.Entry columnTypeEntry : analyticsSchema.getColumns().entrySet()) {
                SchemaColumnBean bean = new SchemaColumnBean();
                bean.setColumnName((String)columnTypeEntry.getKey());
                bean.setColumnType(Utils.getColumnTypeBean((ColumnDefinition)columnTypeEntry.getValue()));
                bean.setScoreParam(((ColumnDefinition)columnTypeEntry.getValue()).isScoreParam());
                bean.setIndex(((ColumnDefinition)columnTypeEntry.getValue()).isIndexed());
                bean.setFacet(((ColumnDefinition)columnTypeEntry.getValue()).isFacet());
                columnBeans.add(bean);
            }
        }
        List primaryKeys = new ArrayList();
        if (analyticsSchema.getPrimaryKeys() != null) {
            primaryKeys = analyticsSchema.getPrimaryKeys();
        }
        return new AnalyticsSchemaBean(columnBeans.toArray(new SchemaColumnBean[columnBeans.size()]), primaryKeys.toArray(new String[primaryKeys.size()]));
    }

    private static String getColumnTypeBean(ColumnDefinition columnDefinition) {
        switch (columnDefinition.getType()) {
            case STRING: {
                return "STRING";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case LONG: {
                return "LONG";
            }
            case FLOAT: {
                return "FLOAT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case BINARY: {
                return "BINARY";
            }
        }
        return "STRING";
    }

    private static RecordValueEntryBean getRecordValueEntryBean(String fieldName, Object value) {
        RecordValueEntryBean recordValueEntryBean = new RecordValueEntryBean();
        recordValueEntryBean.setFieldName(fieldName);
        if (value != null) {
            switch (value.getClass().getSimpleName().toUpperCase()) {
                case "STRING": {
                    recordValueEntryBean.setStringValue(String.valueOf(value));
                    recordValueEntryBean.setType("STRING");
                    break;
                }
                case "INTEGER": {
                    recordValueEntryBean.setIntValue(Integer.parseInt(String.valueOf(value)));
                    recordValueEntryBean.setType("INTEGER");
                    break;
                }
                case "LONG": {
                    recordValueEntryBean.setLongValue(Long.parseLong(String.valueOf(value)));
                    recordValueEntryBean.setType("LONG");
                    break;
                }
                case "BOOLEAN": {
                    recordValueEntryBean.setBooleanValue(Boolean.parseBoolean(String.valueOf(value)));
                    recordValueEntryBean.setType("BOOLEAN");
                    break;
                }
                case "FLOAT": {
                    recordValueEntryBean.setFloatValue(Float.parseFloat(String.valueOf(value)));
                    recordValueEntryBean.setType("FLOAT");
                    break;
                }
                case "DOUBLE": {
                    recordValueEntryBean.setDoubleValue(Double.parseDouble(String.valueOf(value)));
                    recordValueEntryBean.setType("DOUBLE");
                    break;
                }
                default: {
                    recordValueEntryBean.setStringValue(String.valueOf(value));
                    recordValueEntryBean.setType("STRING");
                    break;
                }
            }
        } else {
            recordValueEntryBean.setStringValue(EMPTY_VALUE);
            recordValueEntryBean.setType("STRING");
        }
        return recordValueEntryBean;
    }

    public static StreamDefinition getStreamDefinition(StreamDefinitionBean streamDefinitionBean) throws MalformedStreamDefinitionException, AnalyticsWebServiceException {
        StreamDefinition streamDefinition;
        String name = streamDefinitionBean.getName();
        String version = streamDefinitionBean.getVersion();
        if (name != null && version != null) {
            streamDefinition = new StreamDefinition(name, version);
        } else if (name != null) {
            streamDefinition = new StreamDefinition(name);
        } else {
            throw new AnalyticsWebServiceException("Stream name cannot be empty!");
        }
        streamDefinition.setNickName(streamDefinitionBean.getNickName());
        streamDefinition.setDescription(streamDefinitionBean.getDescription());
        streamDefinition.setCorrelationData(Utils.getAttributeData(streamDefinitionBean.getCorrelationData()));
        streamDefinition.setMetaData(Utils.getAttributeData(streamDefinitionBean.getMetaData()));
        streamDefinition.setPayloadData(Utils.getAttributeData(streamDefinitionBean.getPayloadData()));
        if (streamDefinitionBean.getTags() != null) {
            streamDefinition.setTags(Arrays.asList(streamDefinitionBean.getTags()));
        }
        return streamDefinition;
    }

    private static List<Attribute> getAttributeData(StreamDefAttributeBean[] attributeBeans) throws AnalyticsWebServiceException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (attributeBeans != null) {
            for (StreamDefAttributeBean bean : attributeBeans) {
                Attribute attribute = new Attribute(bean.getName(), Utils.getAttributeType(bean.getType()));
                attributes.add(attribute);
            }
        }
        return attributes;
    }

    private static AttributeType getAttributeType(String type) throws AnalyticsWebServiceException {
        if (type != null) {
            switch (type) {
                case "STRING": {
                    return AttributeType.STRING;
                }
                case "BOOLEAN": {
                    return AttributeType.BOOL;
                }
                case "FLOAT": {
                    return AttributeType.FLOAT;
                }
                case "DOUBLE": {
                    return AttributeType.DOUBLE;
                }
                case "INTEGER": {
                    return AttributeType.INT;
                }
                case "LONG": {
                    return AttributeType.LONG;
                }
            }
            throw new AnalyticsWebServiceException("Unkown type found while reading stream definition bean.");
        }
        throw new AnalyticsWebServiceException("Type is not defined.");
    }

    public static Event getEvent(EventBean eventBean, StreamDefinition streamDefinition) throws AnalyticsWebServiceException {
        Event event = new Event();
        event.setStreamId(streamDefinition.getStreamId());
        event.setTimeStamp(eventBean.getTimeStamp());
        event.setMetaData(Utils.getEventData(eventBean.getMetaData(), streamDefinition.getMetaData()));
        event.setCorrelationData(Utils.getEventData(eventBean.getCorrelationData(), streamDefinition.getCorrelationData()));
        event.setPayloadData(Utils.getEventData(eventBean.getPayloadData(), streamDefinition.getPayloadData()));
        event.setArbitraryDataMap(Utils.getArbitraryValues(eventBean.getArbitraryData()));
        return event;
    }

    private static Map<String, String> getArbitraryValues(RecordValueEntryBean[] arbitraryData) {
        HashMap<String, String> arbitraryDataMap = new HashMap<String, String>();
        if (arbitraryData != null) {
            for (RecordValueEntryBean bean : arbitraryData) {
                arbitraryDataMap.put(bean.getFieldName(), bean.getStringValue());
            }
        }
        if (arbitraryDataMap.isEmpty()) {
            return null;
        }
        return arbitraryDataMap;
    }

    private static Object[] getEventData(RecordValueEntryBean[] beans, List<Attribute> columns) throws AnalyticsWebServiceException {
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, Object> valueEntryBeans = new HashMap<String, Object>();
        if (beans != null) {
            for (RecordValueEntryBean bean : beans) {
                valueEntryBeans.put(bean.getFieldName(), bean);
            }
        }
        if (columns != null) {
            block9: for (Attribute column : columns) {
                if (column != null) {
                    AttributeType type = column.getType();
                    String columnName = column.getName();
                    RecordValueEntryBean bean = (RecordValueEntryBean)valueEntryBeans.get(columnName);
                    if (bean != null) {
                        switch (type) {
                            case DOUBLE: {
                                values.add(new BigDecimal(bean.toString()).doubleValue());
                                continue block9;
                            }
                            case INT: {
                                values.add(new BigDecimal(bean.toString()).intValue());
                                continue block9;
                            }
                            case BOOL: {
                                values.add(Boolean.parseBoolean(bean.toString()));
                                continue block9;
                            }
                            case LONG: {
                                values.add(new BigDecimal(bean.toString()).longValue());
                                continue block9;
                            }
                            case FLOAT: {
                                values.add(Float.valueOf(new BigDecimal(bean.toString()).floatValue()));
                                continue block9;
                            }
                            case STRING: {
                                values.add(bean.toString());
                                continue block9;
                            }
                            default: {
                                throw new AnalyticsWebServiceException("DataType is not valid for [" + bean.getFieldName());
                            }
                        }
                    }
                    throw new AnalyticsWebServiceException("value is not given for field: " + columnName);
                }
                throw new AnalyticsWebServiceException("Record Values are null");
            }
        }
        return values.toArray(new Object[values.size()]);
    }

    public static StreamDefinitionBean getStreamDefinitionBean(StreamDefinition streamDefinition) throws AnalyticsWebServiceException {
        StreamDefinitionBean bean = new StreamDefinitionBean();
        bean.setName(streamDefinition.getName());
        bean.setDescription(streamDefinition.getDescription());
        bean.setNickName(streamDefinition.getNickName());
        bean.setVersion(streamDefinition.getVersion());
        List tags = streamDefinition.getTags();
        List metaData = streamDefinition.getMetaData();
        List correlationData = streamDefinition.getCorrelationData();
        List payloadData = streamDefinition.getPayloadData();
        if (tags != null) {
            bean.setTags(tags.toArray(new String[tags.size()]));
        }
        if (metaData != null) {
            bean.setMetaData(Utils.createStreamDefAttributes(metaData));
        }
        if (correlationData != null) {
            bean.setCorrelationData(Utils.createStreamDefAttributes(correlationData));
        }
        if (payloadData != null) {
            bean.setPayloadData(Utils.createStreamDefAttributes(payloadData));
        }
        return bean;
    }

    private static StreamDefAttributeBean[] createStreamDefAttributes(List<Attribute> attributes) throws AnalyticsWebServiceException {
        ArrayList<StreamDefAttributeBean> beans = new ArrayList<StreamDefAttributeBean>();
        for (Attribute attribute : attributes) {
            StreamDefAttributeBean bean = new StreamDefAttributeBean();
            bean.setName(attribute.getName());
            switch (attribute.getType()) {
                case LONG: {
                    bean.setType("LONG");
                    break;
                }
                case STRING: {
                    bean.setType("STRING");
                    break;
                }
                case BOOL: {
                    bean.setType("BOOLEAN");
                    break;
                }
                case FLOAT: {
                    bean.setType("FLOAT");
                    break;
                }
                case DOUBLE: {
                    bean.setType("DOUBLE");
                    break;
                }
                case INT: {
                    bean.setType("INTEGER");
                    break;
                }
                default: {
                    throw new AnalyticsWebServiceException("Unknown Datatype found in Stream Definition");
                }
            }
            beans.add(bean);
        }
        return beans.toArray(new StreamDefAttributeBean[beans.size()]);
    }

    public static List<Map<String, Object>> getValuesBatch(ValuesBatchBean[] valuesBatchBeans, AnalyticsSchema schema) throws AnalyticsWebServiceException {
        ArrayList<Map<String, Object>> valuesBatch = new ArrayList<Map<String, Object>>();
        Map columns = schema.getColumns();
        if (valuesBatchBeans != null) {
            for (ValuesBatchBean valuesBatchBean : valuesBatchBeans) {
                RecordValueEntryBean[] beans = valuesBatchBean.getKeyValues();
                if (beans != null) {
                    HashMap<String, Object> keyValues = new HashMap<String, Object>();
                    for (RecordValueEntryBean recordValueEntryBean : beans) {
                        String fieldName = recordValueEntryBean.getFieldName();
                        keyValues.put(fieldName, Utils.getObjectValue(((ColumnDefinition)columns.get(fieldName)).getType(), recordValueEntryBean));
                    }
                    if (keyValues.isEmpty()) continue;
                    valuesBatch.add(keyValues);
                    continue;
                }
                throw new AnalyticsWebServiceException("Key values are null in the valuesBatch");
            }
            return valuesBatch;
        }
        throw new AnalyticsWebServiceException("ValuesBatch is null");
    }

    private static Object getObjectValue(AnalyticsSchema.ColumnType type, RecordValueEntryBean recordValueEntryBean) throws AnalyticsWebServiceException {
        Object value;
        switch (type) {
            case FLOAT: {
                value = Float.valueOf(new BigDecimal(recordValueEntryBean.toString()).floatValue());
                break;
            }
            case DOUBLE: {
                value = new BigDecimal(recordValueEntryBean.toString()).doubleValue();
                break;
            }
            case INTEGER: {
                value = new BigDecimal(recordValueEntryBean.toString()).intValue();
                break;
            }
            case LONG: {
                value = new BigDecimal(recordValueEntryBean.toString()).longValue();
                break;
            }
            case BOOLEAN: {
                value = Boolean.parseBoolean(recordValueEntryBean.toString());
                break;
            }
            case STRING: {
                value = recordValueEntryBean.toString();
                break;
            }
            default: {
                throw new AnalyticsWebServiceException("Value cannot be mapped to the data type given in the schema");
            }
        }
        return value;
    }

    public static AnalyticsSchema getAnalyticsSchema(AnalyticsSchemaBean schemaBean) {
        SchemaColumnBean[] columnBeans = schemaBean.getColumns();
        String[] primaryKeys = schemaBean.getPrimaryKeys();
        ArrayList<ColumnDefinitionExt> columnDefinitions = new ArrayList<ColumnDefinitionExt>();
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        if (primaryKeys != null) {
            primaryKeyList.addAll(Arrays.asList(primaryKeys));
        }
        if (columnBeans != null) {
            for (SchemaColumnBean columnBean : columnBeans) {
                ColumnDefinitionExt columnDefinition = new ColumnDefinitionExt(columnBean.getColumnName(), Utils.getColumnType(columnBean.getColumnType()), columnBean.isIndex(), columnBean.isScoreParam(), columnBean.isFacet());
                if (columnBean.getColumnType().equalsIgnoreCase("FACET")) {
                    columnDefinition.setFacet(true);
                }
                columnDefinitions.add(columnDefinition);
            }
        }
        return new AnalyticsSchema(columnDefinitions, primaryKeyList);
    }

    private static AnalyticsSchema.ColumnType getColumnType(String columnType) {
        switch (columnType) {
            case "STRING": {
                return AnalyticsSchema.ColumnType.STRING;
            }
            case "INTEGER": {
                return AnalyticsSchema.ColumnType.INTEGER;
            }
            case "LONG": {
                return AnalyticsSchema.ColumnType.LONG;
            }
            case "FLOAT": {
                return AnalyticsSchema.ColumnType.FLOAT;
            }
            case "DOUBLE": {
                return AnalyticsSchema.ColumnType.DOUBLE;
            }
            case "BOOLEAN": {
                return AnalyticsSchema.ColumnType.BOOLEAN;
            }
            case "BINARY": {
                return AnalyticsSchema.ColumnType.BINARY;
            }
        }
        return AnalyticsSchema.ColumnType.STRING;
    }

    public static AggregateRequest getAggregateRequest(AnalyticsAggregateRequest request) {
        AggregateRequest aggregateRequest = new AggregateRequest();
        aggregateRequest.setTableName(request.getTableName());
        aggregateRequest.setGroupByField(request.getGroupByField());
        aggregateRequest.setQuery(request.getQuery());
        aggregateRequest.setFields(Utils.createAggregateFields(request.getFields()));
        aggregateRequest.setAggregateLevel(request.getAggregateLevel());
        ArrayList<String> parentPath = new ArrayList<String>();
        if (request.getParentPath() != null && request.getParentPath()[0] != null) {
            parentPath.addAll(Arrays.asList(request.getParentPath()));
        }
        aggregateRequest.setParentPath(parentPath);
        aggregateRequest.setNoOfRecords(request.getNoOfRecords());
        return aggregateRequest;
    }

    private static List<AggregateField> createAggregateFields(AnalyticsAggregateField[] fields) {
        ArrayList<AggregateField> aggregateFields = new ArrayList<AggregateField>();
        if (fields != null) {
            for (AnalyticsAggregateField field : fields) {
                AggregateField aggregateField = field.getFieldName() != null && !field.getFieldName().isEmpty() ? new AggregateField(new String[]{field.getFieldName()}, field.getAggregate(), field.getAlias()) : new AggregateField(field.getFields(), field.getAggregate(), field.getAlias());
                aggregateFields.add(aggregateField);
            }
        }
        return aggregateFields;
    }

    public static List<Record> createList(AnalyticsIterator<Record> iterator) {
        ArrayList<Record> records = new ArrayList<Record>();
        records.addAll(IteratorUtils.toList(iterator));
        return records;
    }

    public static AggregateRequest[] getAggregateRequests(AnalyticsAggregateRequest[] requests) {
        ArrayList<AggregateRequest> aggregateRequests = new ArrayList<AggregateRequest>();
        if (requests != null) {
            for (AnalyticsAggregateRequest request : requests) {
                aggregateRequests.add(Utils.getAggregateRequest(request));
            }
        }
        return aggregateRequests.toArray(new AggregateRequest[aggregateRequests.size()]);
    }

    public static AggregateResponse[] createAggregateResponses(List<AnalyticsIterator<Record>> iterators) {
        ArrayList<AggregateResponse> responses = new ArrayList<AggregateResponse>();
        for (AnalyticsIterator<Record> iterator : iterators) {
            List<Record> records = Utils.createList(iterator);
            if (records.isEmpty()) continue;
            AggregateResponse response = new AggregateResponse();
            response.setTableName(records.get(0).getTableName());
            response.setRecordBeans(records.toArray(new RecordBean[records.size()]));
            responses.add(response);
        }
        return responses.toArray(new AggregateResponse[responses.size()]);
    }

    public static List<SortByField> getSortByFields(SortByFieldBean[] sortByFieldBeans) throws AnalyticsException {
        ArrayList<SortByField> sortByFields = new ArrayList<SortByField>();
        if (sortByFieldBeans != null) {
            for (SortByFieldBean sortByFieldBean : sortByFieldBeans) {
                SortByField sortByField = new SortByField(sortByFieldBean.getFieldName(), Utils.getSortType(sortByFieldBean.getFieldName(), sortByFieldBean.getSortType()));
                sortByFields.add(sortByField);
            }
        }
        return sortByFields;
    }

    private static SortType getSortType(String field, String sortBy) throws AnalyticsException {
        SortType sortType;
        if (sortBy != null) {
            switch (sortBy) {
                case "ASC": {
                    sortType = SortType.ASC;
                    break;
                }
                case "DESC": {
                    sortType = SortType.DESC;
                    break;
                }
                default: {
                    throw new AnalyticsException("Unknown SORT order: " + sortBy + "for field: " + field);
                }
            }
        } else {
            throw new AnalyticsException("sortType cannot be null for field: " + field);
        }
        return sortType;
    }

    public static List<RecordBean> getSortedRecordBeans(Map<String, RecordBean> recordBeanMap, List<SearchResultEntry> searchResults) {
        ArrayList<RecordBean> sortedRecords = new ArrayList<RecordBean>();
        for (SearchResultEntry searchResultEntry : searchResults) {
            sortedRecords.add(recordBeanMap.get(searchResultEntry.getId()));
        }
        return sortedRecords;
    }
}

