/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.webservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.api.AnalyticsDataAPI;
import org.wso2.carbon.analytics.api.AnalyticsDataAPIUtil;
import org.wso2.carbon.analytics.dataservice.commons.AggregateRequest;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDataResponse;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDrillDownRange;
import org.wso2.carbon.analytics.dataservice.commons.AnalyticsDrillDownRequest;
import org.wso2.carbon.analytics.dataservice.commons.CategoryDrillDownRequest;
import org.wso2.carbon.analytics.dataservice.commons.CategorySearchResultEntry;
import org.wso2.carbon.analytics.dataservice.commons.SubCategories;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsIterator;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.webservice.Utils;
import org.wso2.carbon.analytics.webservice.beans.AggregateResponse;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsAggregateRequest;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsDrillDownRangeBean;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsDrillDownRequestBean;
import org.wso2.carbon.analytics.webservice.beans.AnalyticsSchemaBean;
import org.wso2.carbon.analytics.webservice.beans.CategoryDrillDownRequestBean;
import org.wso2.carbon.analytics.webservice.beans.CategoryPathBean;
import org.wso2.carbon.analytics.webservice.beans.CategorySearchResultEntryBean;
import org.wso2.carbon.analytics.webservice.beans.EventBean;
import org.wso2.carbon.analytics.webservice.beans.RecordBean;
import org.wso2.carbon.analytics.webservice.beans.SortByFieldBean;
import org.wso2.carbon.analytics.webservice.beans.StreamDefinitionBean;
import org.wso2.carbon.analytics.webservice.beans.SubCategoriesBean;
import org.wso2.carbon.analytics.webservice.beans.ValuesBatchBean;
import org.wso2.carbon.analytics.webservice.exception.AnalyticsWebServiceException;
import org.wso2.carbon.analytics.webservice.internal.ServiceHolder;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.event.stream.core.EventStreamService;

public class AnalyticsWebService
extends AbstractAdmin {
    private static final Log logger = LogFactory.getLog(AnalyticsWebService.class);
    private AnalyticsDataAPI analyticsDataAPI = ServiceHolder.getAnalyticsDataAPI();
    private EventStreamService eventStreamService = ServiceHolder.getEventStreamService();
    private static final String AT_SIGN = "@";

    protected String getUsername() {
        return super.getUsername() + AT_SIGN + super.getTenantDomain();
    }

    public String addStreamDefinition(StreamDefinitionBean streamDefinitionBean) throws AnalyticsWebServiceException, MalformedStreamDefinitionException {
        StreamDefinition streamDefinition = Utils.getStreamDefinition(streamDefinitionBean);
        try {
            this.eventStreamService.addEventStreamDefinition(streamDefinition);
            return streamDefinition.getStreamId();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to set the stream definition: [" + streamDefinition.getName() + ":" + streamDefinition.getVersion() + "]" + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to set the stream definition: [" + streamDefinition.getName() + ":" + streamDefinition.getVersion() + "], " + e.getMessage(), e);
        }
    }

    public StreamDefinitionBean getStreamDefinition(String name, String version) throws AnalyticsWebServiceException {
        try {
            StreamDefinition streamDefinition = this.validateAndGetStreamDefinition(name, version);
            if (streamDefinition != null) {
                return Utils.getStreamDefinitionBean(streamDefinition);
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("unable to get the stream definition: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("unable to get the stream definition: " + e.getMessage(), e);
        }
    }

    public void removeStreamDefinition(String name, String version) throws AnalyticsWebServiceException {
        try {
            this.eventStreamService.removeEventStreamDefinition(name, version);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to remove stream definition: [" + name + ":" + version + "]" + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to remove stream definition: [" + name + ":" + version + "], " + e.getMessage(), e);
        }
    }

    private StreamDefinition validateAndGetStreamDefinition(String name, String version) throws AnalyticsWebServiceException {
        StreamDefinition streamDefinition;
        block4: {
            try {
                if (name != null && version != null) {
                    streamDefinition = this.eventStreamService.getStreamDefinition(name, version);
                    break block4;
                }
                if (name != null) {
                    streamDefinition = this.eventStreamService.getStreamDefinition(name);
                    break block4;
                }
                throw new AnalyticsWebServiceException("The stream name is not provided");
            }
            catch (Exception e) {
                logger.error((Object)("Unable to get the stream definition: " + e.getMessage()), (Throwable)e);
                throw new AnalyticsWebServiceException("Unable to get the stream definition: " + e.getMessage(), e);
            }
        }
        return streamDefinition;
    }

    public void publishEvent(EventBean eventBean) throws AnalyticsWebServiceException {
        try {
            StreamDefinition streamDefinition = this.validateAndGetStreamDefinition(eventBean.getStreamName(), eventBean.getStreamVersion());
            Event event = Utils.getEvent(eventBean, streamDefinition);
            this.eventStreamService.publish(event);
        }
        catch (Exception e) {
            logger.error((Object)("unable to publish event: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("unable to publish event: " + e.getMessage(), e);
        }
    }

    public void setTableSchema(String tableName, AnalyticsSchemaBean schemaBean) throws AnalyticsWebServiceException {
        try {
            AnalyticsSchema schema = Utils.getAnalyticsSchema(schemaBean);
            this.analyticsDataAPI.setTableSchema(this.getUsername(), tableName, schema);
        }
        catch (Exception e) {
            logger.error((Object)("unable to set the schema for table: " + tableName + ", " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("unable to set the schema: " + tableName + ", " + e.getMessage(), e);
        }
    }

    public RecordBean[] searchWithAggregates(AnalyticsAggregateRequest request) throws AnalyticsWebServiceException {
        try {
            AggregateRequest aggregateRequest = Utils.getAggregateRequest(request);
            AnalyticsIterator iterator = this.analyticsDataAPI.searchWithAggregates(this.getUsername(), aggregateRequest);
            List<RecordBean> recordBeans = Utils.createRecordBeans(Utils.createList((AnalyticsIterator<Record>)iterator));
            RecordBean[] resultRecordBeans = new RecordBean[recordBeans.size()];
            return recordBeans.toArray(resultRecordBeans);
        }
        catch (Exception e) {
            logger.error((Object)("unable to search with aggregates for table: " + request.getTableName() + ", " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("unable to search with aggregates: " + request.getTableName() + ", " + e.getMessage(), e);
        }
    }

    public AggregateResponse[] searchMultiTablesWithAggregates(AnalyticsAggregateRequest[] requests) throws AnalyticsWebServiceException {
        try {
            AggregateRequest[] aggregateRequest = Utils.getAggregateRequests(requests);
            List iterators = this.analyticsDataAPI.searchWithAggregates(this.getUsername(), aggregateRequest);
            AggregateResponse[] responses = Utils.createAggregateResponses(iterators);
            return responses;
        }
        catch (Exception e) {
            logger.error((Object)("unable to search with aggregates for  multiple tables: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("unable to search with aggregates for multiple tables: " + e.getMessage(), e);
        }
    }

    public AnalyticsSchemaBean getTableSchema(String tableName) throws AnalyticsWebServiceException {
        try {
            return Utils.createTableSchemaBean(this.analyticsDataAPI.getTableSchema(this.getUsername(), tableName));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get table schema[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get table schema for table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public boolean tableExists(String tableName) throws AnalyticsWebServiceException {
        try {
            return this.analyticsDataAPI.tableExists(this.getUsername(), tableName);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to check table[" + tableName + "] exist due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to check status of the table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public String[] listTables() throws AnalyticsWebServiceException {
        try {
            List tables = this.analyticsDataAPI.listTables(this.getUsername());
            if (tables != null) {
                String[] tableNameArray = new String[tables.size()];
                return tables.toArray(tableNameArray);
            }
            return new String[0];
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get table name list due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to list tables due to " + e.getMessage(), e);
        }
    }

    public long getRecordCount(String tableName, long timeFrom, long timeTo) throws AnalyticsWebServiceException {
        try {
            long recordCount = this.analyticsDataAPI.getRecordCount(this.getUsername(), tableName, timeFrom, timeTo);
            if (recordCount == -1L && logger.isDebugEnabled()) {
                logger.debug((Object)("Retrieving record count is not supported for table:" + tableName));
            }
            return recordCount;
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get record count for table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get record count for table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public RecordBean[] getByRange(String tableName, int numPartitionsHint, String[] columns, long timeFrom, long timeTo, int recordsFrom, int recordsCount) throws AnalyticsWebServiceException {
        try {
            ArrayList records;
            ArrayList<String> columnList = null;
            if (columns != null && columns.length != 0 && columns[0] != null) {
                columnList = new ArrayList<String>(Arrays.asList(columns));
            }
            int originalFrom = recordsFrom;
            if (!this.isPaginationSupported(this.getRecordStoreNameByTable(tableName))) {
                recordsCount = recordsFrom + recordsCount;
                recordsFrom = 0;
            }
            AnalyticsDataResponse response = this.analyticsDataAPI.get(this.getUsername(), tableName, numPartitionsHint, columnList, timeFrom, timeTo, recordsFrom, recordsCount);
            if (!this.isPaginationSupported(this.getRecordStoreNameByTable(tableName))) {
                int i;
                Iterator itr = AnalyticsDataAPIUtil.responseToIterator((AnalyticsDataAPI)this.analyticsDataAPI, (AnalyticsDataResponse)response);
                records = new ArrayList();
                for (i = 0; i < originalFrom && itr.hasNext(); ++i) {
                    itr.next();
                }
                for (i = 0; i < recordsCount && itr.hasNext(); ++i) {
                    records.add(itr.next());
                }
            } else {
                records = AnalyticsDataAPIUtil.listRecords((AnalyticsDataAPI)this.analyticsDataAPI, (AnalyticsDataResponse)response);
            }
            List<RecordBean> recordBeans = Utils.createRecordBeans(records);
            RecordBean[] resultRecordBeans = new RecordBean[recordBeans.size()];
            return recordBeans.toArray(resultRecordBeans);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get records from table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get record from table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public RecordBean[] getWithKeyValues(String tableName, int numPartitionsHint, String[] columns, ValuesBatchBean[] valuesBatchBeans) throws AnalyticsWebServiceException {
        try {
            List<String> columnList = null;
            if (columns != null && columns.length != 0 && columns[0] != null) {
                columnList = Arrays.asList(columns);
            }
            List<Map<String, Object>> valuesBatch = Utils.getValuesBatch(valuesBatchBeans, this.analyticsDataAPI.getTableSchema(this.getUsername(), tableName));
            List records = AnalyticsDataAPIUtil.listRecords((AnalyticsDataAPI)this.analyticsDataAPI, (AnalyticsDataResponse)this.analyticsDataAPI.getWithKeyValues(this.getUsername(), tableName, numPartitionsHint, columnList, valuesBatch));
            List<RecordBean> recordBeans = Utils.createRecordBeans(records);
            RecordBean[] resultRecordBeans = new RecordBean[recordBeans.size()];
            return recordBeans.toArray(resultRecordBeans);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get records from table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get record from table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public RecordBean[] getById(String tableName, int numPartitionsHint, String[] columns, String[] ids) throws AnalyticsWebServiceException {
        try {
            ArrayList<String> columnList = null;
            if (columns != null && columns.length != 0 && columns[0] != null) {
                columnList = new ArrayList<String>(Arrays.asList(columns));
            }
            List<String> idList = null;
            if (ids == null) {
                throw new AnalyticsException("Ids cannot be empty!");
            }
            idList = Arrays.asList(ids);
            List records = AnalyticsDataAPIUtil.listRecords((AnalyticsDataAPI)this.analyticsDataAPI, (AnalyticsDataResponse)this.analyticsDataAPI.get(this.getUsername(), tableName, numPartitionsHint, columnList, idList));
            List<RecordBean> recordBeans = Utils.createRecordBeans(records);
            RecordBean[] resultRecordBeans = new RecordBean[recordBeans.size()];
            return recordBeans.toArray(resultRecordBeans);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get records from table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get record from table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public void deleteByIds(String tableName, String[] ids) throws AnalyticsWebServiceException {
        try {
            this.analyticsDataAPI.delete(this.getUsername(), tableName, Arrays.asList(ids));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to delete records from table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to delete record from table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public void clearIndices(String tableName) throws AnalyticsWebServiceException {
        try {
            this.analyticsDataAPI.clearIndexData(this.getUsername(), tableName);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to clear indices from table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to clear indices from table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public RecordBean[] searchWithSorting(String tableName, String query, int start, int count, String[] columns, SortByFieldBean[] sortByFields) throws AnalyticsWebServiceException {
        try {
            List searchResults = this.analyticsDataAPI.search(this.getUsername(), tableName, query, start, count, Utils.getSortByFields(sortByFields));
            String[] recordIds = Utils.getRecordIds(searchResults);
            RecordBean[] recordBeans = this.getById(tableName, 1, columns, recordIds);
            Map<String, RecordBean> recordBeanMap = Utils.createRecordBeansKeyedWithIds(recordBeans);
            List<RecordBean> sortedRecordBeans = Utils.getSortedRecordBeans(recordBeanMap, searchResults);
            RecordBean[] resultRecordBeans = new RecordBean[sortedRecordBeans.size()];
            return sortedRecordBeans.toArray(resultRecordBeans);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get search result for table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get search result from table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public RecordBean[] search(String tableName, String query, int start, int count) throws AnalyticsWebServiceException {
        return this.searchWithSorting(tableName, query, start, count, null, null);
    }

    public int searchCount(String tableName, String query) throws AnalyticsWebServiceException {
        try {
            return this.analyticsDataAPI.searchCount(this.getUsername(), tableName, query);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get search count for table[" + tableName + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get search count from table[" + tableName + "] due to " + e.getMessage(), e);
        }
    }

    public void waitForIndexing(long maxWait) throws AnalyticsWebServiceException {
        try {
            this.analyticsDataAPI.waitForIndexing(maxWait);
        }
        catch (Exception e) {
            logger.error((Object)("An exception occurred: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("An exception occurred: " + e.getMessage(), e);
        }
    }

    public void waitForIndexingForTable(String tableName, long maxWait) throws AnalyticsWebServiceException {
        try {
            this.analyticsDataAPI.waitForIndexing(this.getUsername(), tableName, maxWait);
        }
        catch (Exception e) {
            logger.error((Object)("An exception occurred: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("An exception occurred: " + e.getMessage(), e);
        }
    }

    public void reIndex(String tableName, long startTime, long endTime) throws AnalyticsWebServiceException {
        try {
            this.analyticsDataAPI.reIndex(this.getUsername(), tableName, startTime, endTime);
        }
        catch (Exception e) {
            logger.error((Object)("An exception occurred: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("An exception occurred: " + e.getMessage(), e);
        }
    }

    public void destroy() throws AnalyticsWebServiceException {
        try {
            this.analyticsDataAPI.destroy();
        }
        catch (Exception e) {
            logger.error((Object)("An exception occurred: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("An exception occurred: " + e.getMessage(), e);
        }
    }

    public boolean isPaginationSupported(String recordStoreName) throws AnalyticsWebServiceException {
        try {
            return this.analyticsDataAPI.isPaginationSupported(recordStoreName);
        }
        catch (Exception e) {
            logger.error((Object)("An exception occurred: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("An exception occurred: " + e.getMessage(), e);
        }
    }

    public boolean isRecordCountSupported(String recordStoreName) throws AnalyticsWebServiceException {
        try {
            return this.analyticsDataAPI.isRecordCountSupported(recordStoreName);
        }
        catch (Exception e) {
            logger.error((Object)("An exception occurred: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("An exception occurred: " + e.getMessage(), e);
        }
    }

    public SubCategoriesBean drillDownCategories(CategoryDrillDownRequestBean drillDownRequest) throws AnalyticsWebServiceException {
        SubCategoriesBean subCategoriesBean = new SubCategoriesBean();
        try {
            SubCategories subCategories = this.analyticsDataAPI.drillDownCategories(this.getUsername(), this.getCategoryDrillDownRequest(drillDownRequest));
            subCategoriesBean.setPath(subCategories.getPath());
            if (subCategories.getCategories() != null) {
                subCategoriesBean.setCategories(this.getSearchResultEntryBeans(subCategories));
                subCategoriesBean.setCategoryCount(subCategories.getCategoryCount());
                subCategoriesBean.setPath(subCategories.getPath());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get drill down category information for table[" + drillDownRequest.getTableName() + "] and " + "field[" + drillDownRequest.getFieldName() + "] due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get drill down category information for table[" + drillDownRequest.getTableName() + "] and " + "field[" + drillDownRequest.getFieldName() + "] due to " + e.getMessage(), e);
        }
        return subCategoriesBean;
    }

    private CategorySearchResultEntryBean[] getSearchResultEntryBeans(SubCategories subCategories) {
        CategorySearchResultEntryBean[] searchResultEntryBeans = new CategorySearchResultEntryBean[subCategories.getCategories().size()];
        int i = 0;
        for (CategorySearchResultEntry searchResultEntry : subCategories.getCategories()) {
            CategorySearchResultEntryBean resultEntryBean = new CategorySearchResultEntryBean();
            resultEntryBean.setCategoryName(searchResultEntry.getCategoryValue());
            resultEntryBean.setScore(searchResultEntry.getScore());
            searchResultEntryBeans[i++] = resultEntryBean;
        }
        return searchResultEntryBeans;
    }

    private CategoryDrillDownRequest getCategoryDrillDownRequest(CategoryDrillDownRequestBean drillDownRequest) {
        CategoryDrillDownRequest categoryDrillDownRequest = new CategoryDrillDownRequest();
        categoryDrillDownRequest.setTableName(drillDownRequest.getTableName());
        categoryDrillDownRequest.setFieldName(drillDownRequest.getFieldName());
        categoryDrillDownRequest.setPath(drillDownRequest.getPath());
        categoryDrillDownRequest.setQuery(drillDownRequest.getQuery());
        categoryDrillDownRequest.setScoreFunction(drillDownRequest.getScoreFunction());
        categoryDrillDownRequest.setStart(drillDownRequest.getStart());
        categoryDrillDownRequest.setCount(drillDownRequest.getCount());
        return categoryDrillDownRequest;
    }

    public RecordBean[] drillDownSearch(AnalyticsDrillDownRequestBean drillDownRequest) throws AnalyticsWebServiceException {
        try {
            List searchResults = this.analyticsDataAPI.drillDownSearch(this.getUsername(), this.getAnalyticsDrillDownRequest(drillDownRequest));
            String[] recordIds = Utils.getRecordIds(searchResults);
            RecordBean[] recordBeans = this.getById(drillDownRequest.getTableName(), 1, drillDownRequest.getColumns(), recordIds);
            Map<String, RecordBean> recordBeanMap = Utils.createRecordBeansKeyedWithIds(recordBeans);
            List<RecordBean> sortedRecordBeans = Utils.getSortedRecordBeans(recordBeanMap, searchResults);
            RecordBean[] resultRecordBeans = new RecordBean[sortedRecordBeans.size()];
            return sortedRecordBeans.toArray(resultRecordBeans);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get drill down information due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get drill down information due to " + e.getMessage(), e);
        }
    }

    private AnalyticsDrillDownRequest getAnalyticsDrillDownRequest(AnalyticsDrillDownRequestBean drillDownRequest) throws AnalyticsException {
        AnalyticsDrillDownRequest analyticsDrillDownRequest = new AnalyticsDrillDownRequest();
        analyticsDrillDownRequest.setTableName(drillDownRequest.getTableName());
        analyticsDrillDownRequest.setQuery(drillDownRequest.getQuery());
        analyticsDrillDownRequest.setRangeField(drillDownRequest.getRangeField());
        analyticsDrillDownRequest.setRecordCount(drillDownRequest.getRecordCount());
        analyticsDrillDownRequest.setRecordStartIndex(drillDownRequest.getRecordStart());
        analyticsDrillDownRequest.setScoreFunction(drillDownRequest.getScoreFunction());
        if (drillDownRequest.getCategoryPaths() != null) {
            HashMap<String, List<String>> categoryPath = new HashMap<String, List<String>>();
            for (Serializable serializable : drillDownRequest.getCategoryPaths()) {
                categoryPath.put(((CategoryPathBean)serializable).getFieldName(), ((CategoryPathBean)serializable).getPath() != null ? Arrays.asList(((CategoryPathBean)serializable).getPath()) : null);
            }
            analyticsDrillDownRequest.setCategoryPaths(categoryPath);
        }
        if (drillDownRequest.getRanges() != null) {
            ArrayList<AnalyticsDrillDownRange> drillDownRanges = new ArrayList<AnalyticsDrillDownRange>();
            for (Serializable serializable : drillDownRequest.getRanges()) {
                AnalyticsDrillDownRange drillDownRange = new AnalyticsDrillDownRange();
                drillDownRange.setLabel(((AnalyticsDrillDownRangeBean)serializable).getLabel());
                drillDownRange.setFrom(((AnalyticsDrillDownRangeBean)serializable).getFrom());
                drillDownRange.setTo(((AnalyticsDrillDownRangeBean)serializable).getTo());
                drillDownRange.setScore(((AnalyticsDrillDownRangeBean)serializable).getScore());
                drillDownRanges.add(drillDownRange);
            }
            analyticsDrillDownRequest.setRanges(drillDownRanges);
        }
        analyticsDrillDownRequest.setSortByFields(Utils.getSortByFields(drillDownRequest.getSortByFields()));
        return analyticsDrillDownRequest;
    }

    public double drillDownSearchCount(AnalyticsDrillDownRequestBean drillDownRequest) throws AnalyticsWebServiceException {
        try {
            return this.analyticsDataAPI.drillDownSearchCount(this.getUsername(), this.getAnalyticsDrillDownRequest(drillDownRequest));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get drill down search count information due to " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get drill down search count information due to " + e.getMessage(), e);
        }
    }

    public List<String> listRecordStoreNames() throws AnalyticsWebServiceException {
        try {
            return this.analyticsDataAPI.listRecordStoreNames();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get record store names: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get record store names: " + e.getMessage(), e);
        }
    }

    public void createTable(String recordStoreName, String tableName) throws AnalyticsWebServiceException {
        try {
            this.analyticsDataAPI.createTable(this.getUsername(), recordStoreName, tableName);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create table[" + tableName + "] in record store[" + recordStoreName + "]: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to create table[" + tableName + "] in record store[" + recordStoreName + "]: " + e.getMessage(), e);
        }
    }

    public String getRecordStoreNameByTable(String tableName) throws AnalyticsWebServiceException {
        try {
            return this.analyticsDataAPI.getRecordStoreNameByTable(this.getUsername(), tableName);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to get record store name for table[" + tableName + "]: " + e.getMessage()), (Throwable)e);
            throw new AnalyticsWebServiceException("Unable to get record store name for table[" + tableName + "]: " + e.getMessage(), e);
        }
    }
}

