/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.io.commons;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class GenericUtils {
    private static ThreadLocal<Kryo> kryoTL = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            return new Kryo();
        }
    };

    public static byte[] serializeObject(Object obj) {
        Kryo kryo = kryoTL.get();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (Output out = new Output((OutputStream)byteOut);){
            kryo.writeClassAndObject(out, obj);
            out.flush();
            byte[] data = byteOut.toByteArray();
            ByteBuffer result = ByteBuffer.allocate(data.length + 4);
            result.putInt(data.length);
            result.put(data);
            byte[] byArray = result.array();
            return byArray;
        }
    }

    public static void serializeObject(Object obj, OutputStream out) throws IOException {
        byte[] data = GenericUtils.serializeObject(obj);
        out.write(data, 0, data.length);
    }

    public static Object deserializeObject(byte[] source) {
        if (source == null) {
            return null;
        }
        try (Input input = new Input(Arrays.copyOfRange(source, 4, source.length));){
            Kryo kryo = kryoTL.get();
            Object object = kryo.readClassAndObject(input);
            return object;
        }
    }

    public static Object deserializeObject(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        in = GenericUtils.checkAndGetAvailableStream(in);
        DataInputStream dataIn = new DataInputStream(in);
        int size = dataIn.readInt();
        byte[] buff = new byte[size];
        dataIn.readFully(buff);
        Kryo kryo = kryoTL.get();
        try (Input input = new Input(buff);){
            Object object = kryo.readClassAndObject(input);
            return object;
        }
    }

    private static InputStream checkAndGetAvailableStream(InputStream in) throws IOException {
        InputStream result;
        int n = in.available();
        if (n == 0) {
            PushbackInputStream pin = new PushbackInputStream(in, 1);
            int data = pin.read();
            if (data == -1) {
                throw new EOFException();
            }
            pin.unread(data);
            result = pin;
        } else {
            result = in;
        }
        return result;
    }
}

