/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.ui.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.spark.admin.stub.AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException;
import org.wso2.carbon.analytics.spark.ui.client.AnalyticsExecutionClient;
import org.wso2.carbon.ui.CarbonUIUtil;

public class SaveSparkScriptProcessor
extends HttpServlet {
    private static final long serialVersionUID = 5936476293277591602L;
    private static Log log = LogFactory.getLog(SaveSparkScriptProcessor.class);

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletContext(), (HttpSession)request.getSession());
        ConfigurationContext configContext = (ConfigurationContext)this.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)request.getSession().getAttribute("wso2carbon.admin.service.cookie");
        String scriptName = request.getParameter("name");
        String scriptContent = request.getParameter("queries");
        String operation = request.getParameter("operation");
        String cron = request.getParameter("cronExp");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            try {
                AnalyticsExecutionClient client = new AnalyticsExecutionClient(cookie, serverURL, configContext);
                if (operation != null && operation.equals("update")) {
                    client.updateScript(scriptName, scriptContent, cron);
                } else {
                    client.saveScript(scriptName, scriptContent, cron);
                }
                out.println("Successfully saved the spark sql script " + scriptName);
            }
            catch (AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException e) {
                out.println("Error while saving the script. " + e.getFaultMessage().getAnalyticsProcessorAdminException().getMessage());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while writing to the response..", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveSparkScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (Exception ex) {
            Logger.getLogger(SaveSparkScriptProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getServletInfo() {
        return "used to save the spark script";
    }
}

