/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.spark.ui.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.wso2.carbon.analytics.spark.admin.stub.AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException;
import org.wso2.carbon.analytics.spark.admin.stub.AnalyticsProcessorAdminServiceStub;

public class AnalyticsExecutionClient {
    private AnalyticsProcessorAdminServiceStub stub;

    public AnalyticsExecutionClient(String cookie, String backEndServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backEndServerURL + "AnalyticsProcessorAdminService";
        this.stub = new AnalyticsProcessorAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        int timeout = 3600000;
        this.stub._getServiceClient().getOptions().setTimeOutInMilliSeconds((long)timeout);
        this.stub._getServiceClient().getOptions().setProperty("SO_TIMEOUT", (Object)timeout);
        this.stub._getServiceClient().getOptions().setProperty("CONNECTION_TIMEOUT", (Object)timeout);
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setTimeOutInMilliSeconds((long)timeout);
        option.setProperty("Cookie", (Object)cookie);
    }

    public AnalyticsExecutionClient() {
    }

    public String execute(String query) {
        AnalyticsProcessorAdminServiceStub.AnalyticsQueryResultDto queryResult;
        query = StringEscapeUtils.unescapeHtml((String)query);
        try {
            queryResult = this.stub.executeQuery(query);
        }
        catch (AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException e) {
            e.printStackTrace();
            return this.errorToJson(query, e.getFaultMessage().getAnalyticsProcessorAdminException().getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return this.errorToJson(query, e.getMessage());
        }
        return this.resultToJson(query, queryResult);
    }

    private String errorToJson(String query, String message) {
        JsonObject resObj = new JsonObject();
        JsonObject meta = new JsonObject();
        meta.addProperty("code", (Number)400);
        meta.addProperty("responseMessage", "ERROR EXECUTING QUERY : " + query);
        JsonArray colArray = new JsonArray();
        colArray.add((JsonElement)new JsonPrimitive("ERROR"));
        meta.add("columns", (JsonElement)colArray);
        resObj.add("meta", (JsonElement)meta);
        JsonObject response = new JsonObject();
        JsonArray rows = new JsonArray();
        JsonArray singleRow = new JsonArray();
        singleRow.add((JsonElement)new JsonPrimitive(message));
        rows.add((JsonElement)singleRow);
        response.add("items", (JsonElement)rows);
        resObj.add("response", (JsonElement)response);
        return resObj.toString();
    }

    public AnalyticsProcessorAdminServiceStub.AnalyticsQueryResultDto[] executeScriptContent(String scriptContent) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        return this.stub.execute(scriptContent);
    }

    public void executeScriptContentInBackground(String scriptContent) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        this.stub.executeInBackground(scriptContent);
    }

    public AnalyticsProcessorAdminServiceStub.AnalyticsQueryResultDto[] executeScript(String scriptName) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        return this.stub.executeScript(scriptName);
    }

    public void executeScriptInBackground(String scriptName) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        this.stub.executeScriptInBackground(scriptName);
    }

    public void deleteScript(String scriptName) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        this.stub.deleteScript(scriptName);
    }

    public void saveScript(String scriptName, String scriptContent, String cron) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        this.stub.saveScript(scriptName, scriptContent, cron);
    }

    public void pauseScripts() throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        this.stub.pauseAllScripts();
    }

    public void resumeScripts() throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        this.stub.resumeAllScripts();
    }

    public AnalyticsProcessorAdminServiceStub.AnalyticsScriptDto[] getAllScripts() throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        return this.stub.getAllScripts();
    }

    public AnalyticsProcessorAdminServiceStub.AnalyticsScheduledScriptDto[] getScheduledTaskStatuses() throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        return this.stub.getScheduledTaskStatuses();
    }

    public AnalyticsProcessorAdminServiceStub.AnalyticsScriptDto getScriptContent(String scriptName) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        return this.stub.getScript(scriptName);
    }

    public void updateScript(String scriptName, String scriptContent, String cron) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        String currentSavedContent = null;
        if (scriptContent != null) {
            currentSavedContent = this.stub.getScript(scriptName).getScriptContent();
            this.stub.updateScriptContent(scriptName, scriptContent);
        }
        if (cron != null) {
            try {
                this.stub.updateScriptTask(scriptName, cron);
            }
            catch (Exception ex) {
                if (currentSavedContent != null && !currentSavedContent.trim().isEmpty()) {
                    this.stub.updateScriptContent(scriptName, currentSavedContent);
                }
                throw new AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public String resultToJson(String query, AnalyticsProcessorAdminServiceStub.AnalyticsQueryResultDto res) {
        JsonObject resObj = new JsonObject();
        JsonObject meta = new JsonObject();
        meta.addProperty("code", (Number)200);
        meta.addProperty("responseMessage", "EXECUTED QUERY : " + query);
        JsonArray colArray = new JsonArray();
        if (res != null && res.getColumnNames() != null && !res.getQuery().trim().toLowerCase().startsWith("insert")) {
            for (String col : res.getColumnNames()) {
                if (col == null) continue;
                colArray.add((JsonElement)new JsonPrimitive(col));
            }
        }
        meta.add("columns", (JsonElement)colArray);
        resObj.add("meta", (JsonElement)meta);
        JsonObject response = new JsonObject();
        JsonArray rows = new JsonArray();
        if (res != null && res.getRowsResults() != null) {
            for (AnalyticsProcessorAdminServiceStub.AnalyticsRowResultDto row : res.getRowsResults()) {
                if (row == null) continue;
                JsonArray singleRow = new JsonArray();
                for (String elm : row.getColumnValues()) {
                    if (elm != null) {
                        singleRow.add((JsonElement)new JsonPrimitive(elm));
                        continue;
                    }
                    singleRow.add((JsonElement)new JsonPrimitive("NULL"));
                }
                rows.add((JsonElement)singleRow);
            }
        }
        response.add("items", (JsonElement)rows);
        resObj.add("response", (JsonElement)response);
        return resObj.toString();
    }

    public boolean isAnalyticsExecutionEnabled() throws RemoteException {
        return this.stub.isAnalyticsExecutionEnabled();
    }

    public boolean isAnalyticsScriptExecuting(String scriptName) throws RemoteException {
        return this.stub.isAnalyticsScriptExecuting(scriptName);
    }

    public boolean isAnalyticsTaskExecuting(String scriptName) throws RemoteException, AnalyticsProcessorAdminServiceAnalyticsProcessorAdminExceptionException {
        return this.stub.isAnalyticsTaskExecuting(scriptName);
    }
}

