/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messageconsole.ui.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringEscapeUtils;
import org.wso2.carbon.messageconsole.ui.beans.Column;
import org.wso2.carbon.messageconsole.ui.beans.Record;
import org.wso2.carbon.messageconsole.ui.beans.ResponseResult;

public class ResponseResultSerializer
implements JsonSerializer<ResponseResult> {
    private static final String RESULT = "Result";
    private static final String MESSAGE = "Message";
    private static final String TOTAL_RECORD_COUNT = "TotalRecordCount";
    private static final String ACTUAL_RECORD_COUNT = "ActualRecordCount";
    private static final String SEARCH_TIME = "SearchTime";
    private static final String RECORDS = "Records";

    public JsonElement serialize(ResponseResult responseResult, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(RESULT, responseResult.getResult());
        jsonObject.addProperty(MESSAGE, responseResult.getMessage());
        jsonObject.addProperty(TOTAL_RECORD_COUNT, (Number)responseResult.getTotalRecordCount());
        jsonObject.addProperty(ACTUAL_RECORD_COUNT, (Number)responseResult.getActualRecordCount());
        jsonObject.addProperty(SEARCH_TIME, (Number)responseResult.getSearchTime());
        JsonArray records = new JsonArray();
        if (responseResult.getRecords() != null) {
            for (Record record : responseResult.getRecords()) {
                JsonObject jsonRecord = new JsonObject();
                if (record != null) {
                    for (Column column : record.getColumns()) {
                        jsonRecord.addProperty(column.getKey(), StringEscapeUtils.escapeXml11((String)column.getValue()));
                    }
                }
                records.add((JsonElement)jsonRecord);
            }
        }
        jsonObject.add(RECORDS, (JsonElement)records);
        return jsonObject;
    }
}

