/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messageconsole.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.messageconsole.stub.MessageConsoleStub;
import org.wso2.carbon.analytics.messageconsole.stub.beans.PermissionBean;
import org.wso2.carbon.analytics.messageconsole.stub.beans.ScheduleTaskInfo;
import org.wso2.carbon.analytics.webservice.stub.AnalyticsWebServiceAnalyticsWebServiceExceptionException;
import org.wso2.carbon.analytics.webservice.stub.AnalyticsWebServiceStub;
import org.wso2.carbon.analytics.webservice.stub.beans.AnalyticsCategoryPathBean;
import org.wso2.carbon.analytics.webservice.stub.beans.AnalyticsDrillDownRequestBean;
import org.wso2.carbon.analytics.webservice.stub.beans.AnalyticsSchemaBean;
import org.wso2.carbon.analytics.webservice.stub.beans.CategoryDrillDownRequestBean;
import org.wso2.carbon.analytics.webservice.stub.beans.CategoryPathBean;
import org.wso2.carbon.analytics.webservice.stub.beans.CategorySearchResultEntryBean;
import org.wso2.carbon.analytics.webservice.stub.beans.RecordBean;
import org.wso2.carbon.analytics.webservice.stub.beans.RecordValueEntryBean;
import org.wso2.carbon.analytics.webservice.stub.beans.SchemaColumnBean;
import org.wso2.carbon.analytics.webservice.stub.beans.SubCategoriesBean;
import org.wso2.carbon.analytics.webservice.stub.beans.ValuesBatchBean;
import org.wso2.carbon.messageconsole.ui.beans.Column;
import org.wso2.carbon.messageconsole.ui.beans.FacetBean;
import org.wso2.carbon.messageconsole.ui.beans.Permissions;
import org.wso2.carbon.messageconsole.ui.beans.Record;
import org.wso2.carbon.messageconsole.ui.beans.ResponseArbitraryField;
import org.wso2.carbon.messageconsole.ui.beans.ResponseResult;
import org.wso2.carbon.messageconsole.ui.beans.ResponseTable;
import org.wso2.carbon.messageconsole.ui.beans.ScheduleTask;
import org.wso2.carbon.messageconsole.ui.exception.MessageConsoleException;
import org.wso2.carbon.messageconsole.ui.serializers.ResponseArbitraryFieldsSerializer;
import org.wso2.carbon.messageconsole.ui.serializers.ResponseResultSerializer;

public class MessageConsoleConnector {
    private static final Log log = LogFactory.getLog(MessageConsoleConnector.class);
    private static final String MESSAGE_CONSOLE = "MessageConsole";
    private static final String ANALYTICS_WEB_SERVICE = "AnalyticsWebService";
    private static final String OK = "OK";
    private static final String ERROR = "ERROR";
    public static final String RECORD_ID = "_unique_rec_id";
    public static final String TIMESTAMP = "_timestamp";
    public static final int TYPE_LIST_RECORD = 1;
    public static final int TYPE_TABLE_INFO = 5;
    public static final int TYPE_LIST_ARBITRARY_RECORD = 6;
    public static final int TYPE_GET_TABLE_INFO = 12;
    public static final int TYPE_GET_PURGING_TASK_INFO = 13;
    public static final int TYPE_SAVE_PURGING_TASK_INFO = 14;
    public static final int TYPE_LIST_TABLE = 15;
    public static final int TYPE_GET_FACET_NAME_LIST = 16;
    public static final int TYPE_GET_FACET_CATEGORIES = 17;
    public static final int TYPE_GET_PRIMARY_KEY_LIST = 18;
    public static final int TYPE_CHECK_TOTAL_COUNT_SUPPORT = 19;
    private static final GsonBuilder RESPONSE_RESULT_BUILDER = new GsonBuilder().registerTypeAdapter(ResponseResult.class, (Object)new ResponseResultSerializer());
    private static final GsonBuilder RESPONSE_ARBITRARY_FIELD_BUILDER = new GsonBuilder().registerTypeAdapter(ResponseArbitraryField.class, (Object)new ResponseArbitraryFieldsSerializer());
    public static final Type STRING_ARRAY_TYPE = new TypeToken<String[]>(){}.getType();
    public static final Type FACET_LIST_TYPE = new TypeToken<List<FacetBean>>(){}.getType();
    public static final Type PRIMARY_KEYS_TYPE = new TypeToken<List<Column>>(){}.getType();
    private static final int MAX_CELL_LENGTH = 100;
    private MessageConsoleStub messageConsoleStub;
    private AnalyticsWebServiceStub analyticsWebServiceStub;

    public MessageConsoleConnector(ConfigurationContext configCtx, String backendServerURL, String cookie) {
        try {
            String messageConsoleServiceUrl = backendServerURL + MESSAGE_CONSOLE;
            this.messageConsoleStub = new MessageConsoleStub(configCtx, messageConsoleServiceUrl);
            ServiceClient messageConsoleServiceClient = this.messageConsoleStub._getServiceClient();
            Options options = messageConsoleServiceClient.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
            String analyticsWebServiceUrl = backendServerURL + ANALYTICS_WEB_SERVICE;
            this.analyticsWebServiceStub = new AnalyticsWebServiceStub(configCtx, analyticsWebServiceUrl);
            ServiceClient analyticsServiceClient = this.analyticsWebServiceStub._getServiceClient();
            options = analyticsServiceClient.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Unable to create MessageConsoleStub.", (Throwable)axisFault);
        }
    }

    public Permissions getAvailablePermissionForUser() throws MessageConsoleException {
        Permissions permissions = new Permissions();
        try {
            PermissionBean permissionBean = this.messageConsoleStub.getAvailablePermissions();
            permissions.setListTable(permissionBean.getListTable());
            permissions.setListRecord(permissionBean.getListRecord());
            permissions.setSearchRecord(permissionBean.getSearchRecord());
            permissions.setDeleteRecord(permissionBean.getDeleteRecord());
        }
        catch (Exception e) {
            throw new MessageConsoleException("Unable to check granted message console permissions due to: " + e.getMessage(), e);
        }
        return permissions;
    }

    public String getTableList() {
        Object[] tableList = null;
        try {
            tableList = this.analyticsWebServiceStub.listTables();
        }
        catch (Exception e) {
            log.error((Object)("Unable to get table list:" + e.getMessage()), (Throwable)e);
        }
        if (tableList == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Received an empty table name list!");
            }
            tableList = new String[]{};
        } else {
            Arrays.sort(tableList);
        }
        return new Gson().toJson((Object)tableList);
    }

    public String getRecords(String tableName, long timeFrom, long timeTo, int startIndex, int pageSize, String searchQuery, String facetsJsonString, String primarySearchString, int resultCountLimit) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Search Query: " + searchQuery));
            log.debug((Object)("timeFrom: " + timeFrom));
            log.debug((Object)("timeTo: " + timeTo));
            log.debug((Object)("Start Index: " + startIndex));
            log.debug((Object)("Page Size: " + pageSize));
            log.debug((Object)("Facet String: " + facetsJsonString));
            log.debug((Object)("Primary key String: " + primarySearchString));
        }
        ResponseResult responseResult = new ResponseResult();
        try {
            RecordBean[] resultRecordBeans;
            List primaryKeys = (List)new Gson().fromJson(primarySearchString, PRIMARY_KEYS_TYPE);
            List facetsList = (List)new Gson().fromJson(facetsJsonString, FACET_LIST_TYPE);
            responseResult.setSearchTime(-1L);
            if (primaryKeys != null && !primaryKeys.isEmpty()) {
                ValuesBatchBean batchBean = new ValuesBatchBean();
                ValuesBatchBean[] batchBeans = new ValuesBatchBean[]{batchBean};
                RecordValueEntryBean[] valueEntryBeans = new RecordValueEntryBean[primaryKeys.size()];
                int i = 0;
                for (Column primaryKey : primaryKeys) {
                    RecordValueEntryBean entryBean = new RecordValueEntryBean();
                    entryBean.setFieldName(primaryKey.getKey());
                    entryBean.setStringValue(primaryKey.getValue());
                    valueEntryBeans[i++] = entryBean;
                }
                batchBean.setKeyValues(valueEntryBeans);
                resultRecordBeans = this.analyticsWebServiceStub.getWithKeyValues(tableName, 1, null, batchBeans);
            } else if (facetsList != null && !facetsList.isEmpty()) {
                long startingTime = System.currentTimeMillis();
                AnalyticsDrillDownRequestBean requestBean = this.getAnalyticsDrillDownRequestBean(tableName, startIndex, pageSize, searchQuery, facetsList);
                resultRecordBeans = this.analyticsWebServiceStub.drillDownSearch(requestBean);
                long searchCount = (long)this.analyticsWebServiceStub.drillDownSearchCount(requestBean);
                responseResult.setSearchTime(System.currentTimeMillis() - startingTime);
                responseResult.setActualRecordCount(searchCount);
                if (responseResult.getActualRecordCount() > (long)resultCountLimit) {
                    responseResult.setTotalRecordCount(resultCountLimit);
                } else {
                    responseResult.setTotalRecordCount(searchCount);
                }
            } else if (searchQuery != null && !searchQuery.isEmpty()) {
                long startingTime = System.currentTimeMillis();
                resultRecordBeans = this.analyticsWebServiceStub.search(tableName, searchQuery, startIndex, pageSize);
                long searchCount = this.analyticsWebServiceStub.searchCount(tableName, searchQuery);
                responseResult.setSearchTime(System.currentTimeMillis() - startingTime);
                responseResult.setActualRecordCount(searchCount);
                if (responseResult.getActualRecordCount() > (long)resultCountLimit) {
                    responseResult.setTotalRecordCount(resultCountLimit);
                } else {
                    responseResult.setTotalRecordCount(searchCount);
                }
            } else {
                String recordStoreName = this.analyticsWebServiceStub.getRecordStoreNameByTable(tableName);
                boolean isRecordCountSupported = this.analyticsWebServiceStub.isRecordCountSupported(recordStoreName);
                long totalRecordCount = -1L;
                if (isRecordCountSupported) {
                    totalRecordCount = this.analyticsWebServiceStub.getRecordCount(tableName, timeFrom, timeTo);
                    responseResult.setActualRecordCount(totalRecordCount);
                    responseResult.setTotalRecordCount(totalRecordCount);
                } else {
                    responseResult.setActualRecordCount(totalRecordCount);
                    responseResult.setTotalRecordCount(resultCountLimit);
                }
                resultRecordBeans = this.analyticsWebServiceStub.getByRange(tableName, 1, null, timeFrom, timeTo, startIndex, pageSize);
            }
            ArrayList<Record> records = new ArrayList<Record>();
            if (resultRecordBeans != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result size: " + resultRecordBeans.length));
                }
                for (RecordBean recordBean : resultRecordBeans) {
                    if (recordBean == null) continue;
                    Record record = this.getRecord(recordBean, true);
                    if (record.getColumns() != null && !record.getColumns().isEmpty()) {
                        for (Column column : record.getColumns()) {
                            if (!"STRING".equals(column.getType()) || column.getValue() == null || column.getValue().isEmpty() || column.getValue().length() <= 100) continue;
                            column.setValue(column.getValue().substring(0, 100).concat("..."));
                        }
                    }
                    records.add(record);
                }
                responseResult.setRecords(records);
            }
            responseResult.setResult(OK);
        }
        catch (Exception e) {
            String errorMsg = "Unable to get records for table:" + tableName;
            log.error((Object)errorMsg, (Throwable)e);
            responseResult.setResult(ERROR);
            responseResult.setMessage(errorMsg);
        }
        return RESPONSE_RESULT_BUILDER.serializeNulls().create().toJson((Object)responseResult);
    }

    private AnalyticsDrillDownRequestBean getAnalyticsDrillDownRequestBean(String tableName, int startIndex, int pageSize, String searchQuery, List<FacetBean> facetsList) {
        AnalyticsDrillDownRequestBean requestBean = new AnalyticsDrillDownRequestBean();
        requestBean.setTableName(tableName);
        requestBean.setRecordStart(startIndex);
        requestBean.setRecordCount(pageSize);
        if (searchQuery != null && searchQuery.isEmpty()) {
            searchQuery = null;
        }
        requestBean.setQuery(searchQuery);
        CategoryPathBean[] pathBeans = new CategoryPathBean[facetsList.size()];
        for (int i = 0; i < facetsList.size(); ++i) {
            FacetBean facetBean = facetsList.get(i);
            CategoryPathBean categoryPathBean = new CategoryPathBean();
            categoryPathBean.setFieldName(facetBean.getField());
            categoryPathBean.setPath(facetBean.getPath().toArray(new String[facetBean.getPath().size()]));
            pathBeans[i] = categoryPathBean;
        }
        requestBean.setCategoryPaths(pathBeans);
        return requestBean;
    }

    private Record getRecord(RecordBean recordBean, boolean withDefaultColumn) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        Record record = new Record();
        if (recordBean != null) {
            ArrayList<Column> columns = new ArrayList<Column>();
            if (withDefaultColumn) {
                columns.add(new Column(RECORD_ID, recordBean.getId()));
                columns.add(new Column(TIMESTAMP, dateFormat.format(new Date(recordBean.getTimestamp()))));
            }
            if (recordBean.getValues() != null) {
                for (RecordValueEntryBean entityBean : recordBean.getValues()) {
                    columns.add(this.getColumn(entityBean));
                }
            }
            record.setColumns(columns);
        }
        return record;
    }

    private Column getColumn(RecordValueEntryBean entityBean) {
        String value = null;
        switch (entityBean.getType()) {
            case "STRING": {
                value = entityBean.getStringValue();
                break;
            }
            case "INTEGER": {
                value = String.valueOf(entityBean.getIntValue());
                break;
            }
            case "LONG": {
                value = String.valueOf(entityBean.getLongValue());
                break;
            }
            case "FLOAT": {
                value = String.valueOf(entityBean.getFloatValue());
                break;
            }
            case "DOUBLE": {
                value = String.valueOf(entityBean.getDoubleValue());
                break;
            }
            case "BOOLEAN": {
                value = String.valueOf(entityBean.getBooleanValue());
                break;
            }
            case "FACET": {
                AnalyticsCategoryPathBean analyticsCategoryPathBeanValue = entityBean.getAnalyticsCategoryPathBeanValue();
                FacetBean facetBean = new FacetBean();
                if (analyticsCategoryPathBeanValue != null && analyticsCategoryPathBeanValue.getPath() != null) {
                    facetBean.setPath(Arrays.asList(analyticsCategoryPathBeanValue.getPath()));
                } else {
                    facetBean.setPath(new ArrayList<String>(0));
                }
                value = String.valueOf(new Gson().toJson((Object)facetBean));
                break;
            }
        }
        Column column = new Column(entityBean.getFieldName(), value, entityBean.getType());
        return column;
    }

    public String getTableInfo(String tableName) {
        ResponseTable table = new ResponseTable();
        table.setName(tableName);
        try {
            AnalyticsSchemaBean tableSchema = this.analyticsWebServiceStub.getTableSchema(tableName);
            ArrayList<ResponseTable.Column> columns = new ArrayList<ResponseTable.Column>();
            if (tableSchema.getColumns() != null) {
                List<String> primaryKeys = null;
                if (tableSchema.getPrimaryKeys() != null) {
                    primaryKeys = Arrays.asList(tableSchema.getPrimaryKeys());
                }
                for (SchemaColumnBean resultColumn : tableSchema.getColumns()) {
                    ResponseTable.Column column = new ResponseTable.Column();
                    column.setName(resultColumn.getColumnName());
                    column.setType(resultColumn.getColumnType());
                    column.setDisplay(true);
                    if (primaryKeys != null && primaryKeys.contains(resultColumn.getColumnName())) {
                        column.setPrimary(true);
                    }
                    columns.add(column);
                }
            }
            ResponseTable.Column recordId = new ResponseTable.Column();
            recordId.setName(RECORD_ID);
            recordId.setPrimary(false);
            recordId.setType("STRING");
            recordId.setDisplay(false);
            recordId.setKey(true);
            columns.add(recordId);
            ResponseTable.Column timestamp = new ResponseTable.Column();
            timestamp.setName(TIMESTAMP);
            timestamp.setPrimary(false);
            timestamp.setType("STRING");
            timestamp.setDisplay(true);
            columns.add(timestamp);
            table.setColumns(columns);
            table.setPaginationSupport(this.analyticsWebServiceStub.isPaginationSupported(this.analyticsWebServiceStub.getRecordStoreNameByTable(tableName)));
        }
        catch (Exception e) {
            log.error((Object)("Unable to get table information for table:" + tableName), (Throwable)e);
        }
        return new GsonBuilder().serializeNulls().create().toJson((Object)table);
    }

    private Record getRecord(String table, String recordId, boolean withDefaultColumns) throws RemoteException, AnalyticsWebServiceAnalyticsWebServiceExceptionException {
        String[] ids = new String[]{recordId};
        RecordBean[] recordBeans = this.analyticsWebServiceStub.getById(table, 1, null, ids);
        if (recordBeans != null && recordBeans.length > 0) {
            return this.getRecord(recordBeans[0], withDefaultColumns);
        }
        return null;
    }

    public String getArbitraryFields(String table, String recordId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get arbitrary field values for recordId [" + recordId + "] in table[" + table + "]"));
        }
        ResponseArbitraryField responseArbitraryField = new ResponseArbitraryField();
        responseArbitraryField.setResult(OK);
        HashSet<Column> resultColumns = new HashSet<Column>();
        try {
            Record originalRecord = this.getRecord(table, recordId, false);
            AnalyticsSchemaBean schema = this.analyticsWebServiceStub.getTableSchema(table);
            if (originalRecord != null) {
                List<Column> columns = originalRecord.getColumns();
                if (schema != null) {
                    SchemaColumnBean[] schemaColumns;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Table schema[" + table + "] is not null"));
                    }
                    if ((schemaColumns = schema.getColumns()) != null && schemaColumns.length > 0) {
                        for (Column column : columns) {
                            boolean arbitraryField = true;
                            for (SchemaColumnBean schemaColumnBean : schemaColumns) {
                                if (!column.getKey().equals(schemaColumnBean.getColumnName())) continue;
                                arbitraryField = false;
                                break;
                            }
                            if (!arbitraryField) continue;
                            resultColumns.add(column);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Either table schema[" + table + "] null or empty. Adding all records to " + "arbitrary list"));
                        }
                        for (Column column : columns) {
                            resultColumns.add(column);
                        }
                    }
                }
                if (columns != null && !columns.isEmpty()) {
                    for (Column column : columns) {
                        if (!"STRING".equals(column.getType()) || column.getValue() == null || column.getValue().isEmpty() || column.getValue().length() <= 100) continue;
                        resultColumns.add(column);
                    }
                }
            }
            responseArbitraryField.setColumns(new ArrayList<Column>(resultColumns));
        }
        catch (Exception e) {
            String errorMsg = "Unable to get arbitrary fields for record[" + recordId + "] in table[" + table + "]";
            log.error((Object)errorMsg, (Throwable)e);
            responseArbitraryField.setResult(ERROR);
            responseArbitraryField.setMessage(errorMsg);
        }
        return RESPONSE_ARBITRARY_FIELD_BUILDER.serializeNulls().create().toJson((Object)responseArbitraryField);
    }

    public String scheduleDataPurging(String table, String time, String retentionPeriod, boolean enable) {
        String msg;
        String cron = null;
        if (enable) {
            if (time != null && time.length() == 5) {
                int hour = Integer.parseInt(time.substring(0, 2));
                int min = Integer.parseInt(time.substring(3));
                cron = "0 " + min + " " + hour + " * * ?";
            } else {
                cron = time;
            }
        }
        if (!retentionPeriod.matches("^-?\\d+$")) {
            msg = "Please enter valid number for \"Purge Record Older Than \" field.";
        } else {
            try {
                this.messageConsoleStub.scheduleDataPurging(table, cron, Integer.parseInt(retentionPeriod));
                msg = enable ? "Data purging task for " + table + " scheduled successfully." : "Data purging task for " + table + " removed successfully.";
            }
            catch (Exception e) {
                msg = "Unable to schedule task due to " + e.getMessage();
                log.error((Object)("Unable to schedule data puring task for " + table), (Throwable)e);
            }
        }
        return msg;
    }

    public String getDataPurgingDetails(String table) {
        ScheduleTask scheduleTask = new ScheduleTask();
        try {
            ScheduleTaskInfo dataPurgingDetails = this.messageConsoleStub.getDataPurgingDetails(table);
            if (dataPurgingDetails != null) {
                scheduleTask.setCronString(dataPurgingDetails.getCronString());
                scheduleTask.setRetentionPeriod(dataPurgingDetails.getRetentionPeriod());
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to get schedule task information for table:" + table), (Throwable)e);
        }
        return new Gson().toJson((Object)scheduleTask);
    }

    public String getFacetColumnNameList(String table) {
        ArrayList<String> facetNameList = new ArrayList<String>();
        try {
            AnalyticsSchemaBean tableSchema = this.analyticsWebServiceStub.getTableSchema(table);
            if (tableSchema != null && tableSchema.getColumns() != null) {
                for (SchemaColumnBean schemaColumnBean : tableSchema.getColumns()) {
                    if (!schemaColumnBean.getFacet()) continue;
                    facetNameList.add(schemaColumnBean.getColumnName());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to get facet column list for table:" + table), (Throwable)e);
        }
        return new Gson().toJson((Object)facetNameList.toArray(new String[facetNameList.size()]));
    }

    public String getPrimaryKeys(String table) {
        try {
            AnalyticsSchemaBean tableSchema = this.analyticsWebServiceStub.getTableSchema(table);
            if (tableSchema != null && tableSchema.getPrimaryKeys() != null) {
                return new Gson().toJson((Object)tableSchema.getPrimaryKeys());
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to get facet column list for table:" + table), (Throwable)e);
        }
        return new Gson().toJson((Object)new String[0]);
    }

    public String getFacetCategoryList(String table, String fieldName, String categoryPaths) {
        CategoryDrillDownRequestBean drillDownRequestBean = new CategoryDrillDownRequestBean();
        drillDownRequestBean.setTableName(table);
        drillDownRequestBean.setFieldName(fieldName);
        if (categoryPaths != null && !categoryPaths.isEmpty()) {
            String[] path = (String[])new Gson().fromJson(categoryPaths, STRING_ARRAY_TYPE);
            drillDownRequestBean.setPath(path);
        } else {
            drillDownRequestBean.setPath(null);
        }
        ArrayList<String> categories = new ArrayList<String>();
        try {
            SubCategoriesBean subCategoriesBean = this.analyticsWebServiceStub.drillDownCategories(drillDownRequestBean);
            if (subCategoriesBean != null && subCategoriesBean.getCategories() != null) {
                for (CategorySearchResultEntryBean categorySearchResultEntryBean : subCategoriesBean.getCategories()) {
                    categories.add(categorySearchResultEntryBean.getCategoryName());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to get facet sub category for table[" + table + "], field [" + fieldName + "] and " + "path[" + categoryPaths + "]"), (Throwable)e);
        }
        return new Gson().toJson(categories);
    }

    public boolean isRecordCountSupported(String tableName) {
        try {
            return this.analyticsWebServiceStub.isRecordCountSupported(this.analyticsWebServiceStub.getRecordStoreNameByTable(tableName));
        }
        catch (Exception e) {
            log.error((Object)("Unable to check record count support status for table " + tableName), (Throwable)e);
            return false;
        }
    }
}

