/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messageconsole.ui.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringEscapeUtils;
import org.wso2.carbon.messageconsole.ui.beans.Column;
import org.wso2.carbon.messageconsole.ui.beans.ResponseArbitraryField;

public class ResponseArbitraryFieldsSerializer
implements JsonSerializer<ResponseArbitraryField> {
    private static final String RESULT = "Result";
    private static final String MESSAGE = "Message";
    private static final String RECORDS = "Records";
    private static final String NAME = "Name";
    private static final String VALUE = "Value";
    private static final String TYPE = "Type";

    public JsonElement serialize(ResponseArbitraryField responseArbitraryField, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(RESULT, responseArbitraryField.getResult());
        jsonObject.addProperty(MESSAGE, responseArbitraryField.getMessage());
        JsonArray records = new JsonArray();
        if (responseArbitraryField.getColumns() != null) {
            for (Column column : responseArbitraryField.getColumns()) {
                JsonObject jsonRecord = new JsonObject();
                jsonRecord.addProperty(NAME, column.getKey());
                jsonRecord.addProperty(VALUE, StringEscapeUtils.escapeXml11((String)column.getValue()));
                jsonRecord.addProperty(TYPE, column.getType());
                records.add((JsonElement)jsonRecord);
            }
        }
        jsonObject.add(RECORDS, (JsonElement)records);
        return jsonObject;
    }
}

