/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinition;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinitionExt;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventStore;
import org.wso2.carbon.analytics.eventsink.AnalyticsTableSchema;
import org.wso2.carbon.analytics.eventsink.exception.AnalyticsEventStoreException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;

public class AnalyticsEventSinkUtil {
    public static String generateAnalyticsTableName(String streamName) {
        String tableName = "";
        if (streamName != null && !streamName.isEmpty()) {
            tableName = streamName.replace('.', '_');
        }
        return tableName;
    }

    public static AnalyticsSchema getAnalyticsSchema(AnalyticsTableSchema tableSchema) throws AnalyticsEventStoreException {
        return new AnalyticsSchema(AnalyticsEventSinkUtil.getColumnDefinitions(tableSchema.getColumns()), AnalyticsEventSinkUtil.getPrimaryKeys(tableSchema.getColumns()));
    }

    private static List<ColumnDefinition> getColumnDefinitions(List<AnalyticsTableSchema.Column> columns) throws AnalyticsEventStoreException {
        ArrayList<ColumnDefinition> schemaColumns = new ArrayList<ColumnDefinition>();
        if (columns != null) {
            for (AnalyticsTableSchema.Column schemaColumn : columns) {
                ColumnDefinitionExt columnDefinition = new ColumnDefinitionExt();
                columnDefinition.setName(schemaColumn.getColumnName());
                columnDefinition.setIndexed(schemaColumn.isIndexed());
                columnDefinition.setScoreParam(schemaColumn.isScoreParam());
                if (schemaColumn.getType() == AnalyticsSchema.ColumnType.FACET) {
                    columnDefinition.setType(AnalyticsSchema.ColumnType.STRING);
                    columnDefinition.setFacet(true);
                } else {
                    if (schemaColumn.getType() == null) {
                        throw new AnalyticsEventStoreException("Invalid type for field: " + schemaColumn.getColumnName() + " in eventStore configuration");
                    }
                    columnDefinition.setType(schemaColumn.getType());
                    columnDefinition.setFacet(schemaColumn.isFacet());
                }
                schemaColumns.add((ColumnDefinition)columnDefinition);
            }
        }
        return schemaColumns;
    }

    private static List<String> getPrimaryKeys(List<AnalyticsTableSchema.Column> columns) {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        if (columns != null) {
            for (AnalyticsTableSchema.Column schemaColumn : columns) {
                if (!schemaColumn.isPrimaryKey()) continue;
                primaryKeys.add(schemaColumn.getColumnName());
            }
        }
        return primaryKeys;
    }

    public static String getAnalyticsEventStoreName(String deploymentFileName) {
        if ((deploymentFileName = GenericUtils.checkAndReturnPath((String)deploymentFileName)).contains(".xml")) {
            return deploymentFileName.substring(0, deploymentFileName.length() - ".xml".length());
        }
        return deploymentFileName;
    }

    public static AnalyticsEventStore getAnalyticsEventStore(String streamName, String version, AnalyticsSchema schema, String recordStoreName) throws AnalyticsEventStoreException {
        AnalyticsEventStore store = new AnalyticsEventStore();
        AnalyticsEventStore.EventSource eventSource = new AnalyticsEventStore.EventSource();
        ArrayList<String> streams = new ArrayList<String>();
        streams.add(DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)version));
        eventSource.setStreamIds(streams);
        store.setEventSource(eventSource);
        store.setAnalyticsTableSchema(AnalyticsEventSinkUtil.getAnalyticsTableSchema(schema));
        store.setRecordStore(recordStoreName);
        return store;
    }

    private static AnalyticsTableSchema getAnalyticsTableSchema(AnalyticsSchema schema) throws AnalyticsEventStoreException {
        AnalyticsTableSchema tableSchema = new AnalyticsTableSchema();
        ArrayList<AnalyticsTableSchema.Column> columns = new ArrayList<AnalyticsTableSchema.Column>();
        Set columnDefs = schema.getColumns().entrySet();
        for (Map.Entry column : columnDefs) {
            AnalyticsTableSchema.Column analyticsColumn = new AnalyticsTableSchema.Column();
            analyticsColumn.setColumnName((String)column.getKey());
            analyticsColumn.setIndexed(((ColumnDefinition)column.getValue()).isIndexed());
            analyticsColumn.setScoreParam(((ColumnDefinition)column.getValue()).isScoreParam());
            if (((ColumnDefinition)column.getValue()).getType() == null) {
                throw new AnalyticsEventStoreException("Invalid type for field: " + (String)column.getKey() + " in eventStore configuration");
            }
            analyticsColumn.setType(((ColumnDefinition)column.getValue()).getType());
            analyticsColumn.setFacet(((ColumnDefinition)column.getValue()).isFacet());
            if (schema.getPrimaryKeys().contains(column.getKey())) {
                analyticsColumn.setPrimaryKey(true);
            }
            columns.add(analyticsColumn);
        }
        tableSchema.setColumns(columns);
        return tableSchema;
    }

    public static AnalyticsEventStore copyAnalyticsEventStore(AnalyticsEventStore analyticsEventStore) throws AnalyticsEventStoreException {
        AnalyticsEventStore copyStore = new AnalyticsEventStore();
        copyStore.setEventSource(AnalyticsEventSinkUtil.copyEventSource(analyticsEventStore.getEventSource()));
        copyStore.setAnalyticsTableSchema(AnalyticsEventSinkUtil.copyAnalyticsTableSchema(analyticsEventStore.getAnalyticsTableSchema()));
        return copyStore;
    }

    private static AnalyticsEventStore.EventSource copyEventSource(AnalyticsEventStore.EventSource eventSource) {
        AnalyticsEventStore.EventSource copyEventSource = new AnalyticsEventStore.EventSource();
        ArrayList<String> streamIds = new ArrayList<String>();
        for (String streamId : eventSource.getStreamIds()) {
            streamIds.add(streamId);
        }
        copyEventSource.setStreamIds(streamIds);
        return copyEventSource;
    }

    private static AnalyticsTableSchema copyAnalyticsTableSchema(AnalyticsTableSchema analyticsTableSchema) throws AnalyticsEventStoreException {
        AnalyticsTableSchema copySchema = new AnalyticsTableSchema();
        ArrayList<AnalyticsTableSchema.Column> columns = new ArrayList<AnalyticsTableSchema.Column>();
        for (AnalyticsTableSchema.Column originalCol : analyticsTableSchema.getColumns()) {
            AnalyticsTableSchema.Column column = new AnalyticsTableSchema.Column();
            column.setColumnName(originalCol.getColumnName());
            column.setIndexed(originalCol.isIndexed());
            column.setPrimaryKey(originalCol.isPrimaryKey());
            column.setScoreParam(originalCol.isScoreParam());
            if (originalCol.getType() == AnalyticsSchema.ColumnType.FACET) {
                column.setType(AnalyticsSchema.ColumnType.STRING);
                column.setFacet(true);
            } else {
                if (originalCol.getType() == null) {
                    throw new AnalyticsEventStoreException("Invalid type for field: " + originalCol.getColumnName() + " in eventStore configuration");
                }
                column.setType(originalCol.getType());
                column.setFacet(originalCol.isFacet());
            }
            columns.add(column);
        }
        copySchema.setColumns(columns);
        return copySchema;
    }

    public static String getEventSources(List<String> streamIds) {
        if (streamIds != null && !streamIds.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("");
            for (String streamId : streamIds) {
                stringBuilder.append(streamId).append(", ");
            }
            if (stringBuilder.length() - 2 == stringBuilder.lastIndexOf(", ")) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length() - 1);
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return null;
        }
        return null;
    }
}

