/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal.queue;

import com.lmax.disruptor.EventHandler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.eventsink.internal.queue.AnalyticsBlockingExecutor;
import org.wso2.carbon.analytics.eventsink.internal.queue.AnalyticsEventQueue;
import org.wso2.carbon.analytics.eventsink.internal.queue.WrappedEventFactory;
import org.wso2.carbon.analytics.eventsink.internal.util.ServiceHolder;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.databridge.commons.Event;

public class AnalyticsEventQueueWorker
implements EventHandler<WrappedEventFactory.WrappedEvent> {
    private static final Log log = LogFactory.getLog(AnalyticsEventQueueWorker.class);
    private AnalyticsEventQueue queue;
    private List<Event> events;
    private int tenantId;
    private int totalSize;
    private AnalyticsBlockingExecutor threadPoolExecutor;

    public AnalyticsEventQueueWorker(int tenantId, AnalyticsEventQueue queue) {
        this.tenantId = tenantId;
        this.events = new ArrayList<Event>();
        this.queue = queue;
        this.threadPoolExecutor = new AnalyticsBlockingExecutor(ServiceHolder.getAnalyticsEventSinkConfiguration().getWorkerPoolSize());
        this.totalSize = 0;
    }

    public void onEvent(WrappedEventFactory.WrappedEvent wrappedEvent, long sequence, boolean endOfBatch) throws Exception {
        if (this.totalSize + wrappedEvent.getSize() > ServiceHolder.getAnalyticsEventSinkConfiguration().getBatchSize()) {
            if (!this.events.isEmpty()) {
                this.pushEvents();
                this.events.add(wrappedEvent.getEvent());
                this.totalSize += wrappedEvent.getSize();
            } else {
                this.events.add(wrappedEvent.getEvent());
                this.totalSize += wrappedEvent.getSize();
                this.pushEvents();
            }
        } else {
            this.events.add(wrappedEvent.getEvent());
            this.totalSize += wrappedEvent.getSize();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Collecting events, current totalSize : " + this.totalSize));
            }
        }
        if (endOfBatch && !this.events.isEmpty()) {
            this.pushEvents();
        }
        this.queue.notifyReleasedEvent(wrappedEvent, endOfBatch);
    }

    private void pushEvents() {
        List<Event> tmpEvents = this.events;
        this.events = new ArrayList<Event>();
        this.submitJob(tmpEvents);
        this.totalSize = 0;
    }

    private void submitJob(List<Event> tmpEvents) {
        this.threadPoolExecutor.submit(new AnalyticsEventProcessor(tmpEvents, this.totalSize));
    }

    public class AnalyticsEventProcessor
    extends Thread {
        private List<Event> events;
        private int size;

        private AnalyticsEventProcessor(List<Event> events, int totalSize) {
            this.events = events;
            this.size = totalSize;
        }

        @Override
        public void run() {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(AnalyticsEventQueueWorker.this.tenantId, true);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Batch size of : " + this.size + " is going to be inserted in DAL"));
                }
                ServiceHolder.getAnalyticsDSConnector().insertEvents(AnalyticsEventQueueWorker.this.tenantId, this.events);
            }
            catch (Exception e) {
                String errorMsg = "Error processing event. ";
                log.error((Object)errorMsg, (Throwable)e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }
}

