/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal.queue;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.eventsink.internal.queue.AnalyticsEventQueue;
import org.wso2.carbon.databridge.commons.Event;

public class AnalyticsEventQueueManager {
    private static final Log log = LogFactory.getLog(AnalyticsEventQueueManager.class);
    private static AnalyticsEventQueueManager instance = new AnalyticsEventQueueManager();
    private static ConcurrentHashMap<Integer, AnalyticsEventQueue> queueMap = new ConcurrentHashMap();

    private AnalyticsEventQueueManager() {
    }

    public static AnalyticsEventQueueManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int tenantId, Event event) {
        AnalyticsEventQueue eventQueue = queueMap.get(tenantId);
        if (eventQueue == null) {
            AnalyticsEventQueueManager analyticsEventQueueManager = this;
            synchronized (analyticsEventQueueManager) {
                eventQueue = queueMap.get(tenantId);
                if (eventQueue == null) {
                    eventQueue = new AnalyticsEventQueue(tenantId);
                    queueMap.put(tenantId, eventQueue);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding event : " + event));
        }
        eventQueue.put(event);
    }

    public AnalyticsEventQueue getAnalyticsEventQueue(int tenantId) {
        return queueMap.get(tenantId);
    }
}

