/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal.queue;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AnalyticsBlockingExecutor
extends ThreadPoolExecutor {
    private final Semaphore semaphore;

    public AnalyticsBlockingExecutor(int poolSize) {
        super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.semaphore = new Semaphore(poolSize);
    }

    @Override
    public void execute(Runnable task) {
        boolean acquired = false;
        do {
            try {
                this.semaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!acquired);
        super.execute(task);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.semaphore.release();
    }
}

