/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventStore;
import org.wso2.carbon.analytics.eventsink.exception.AnalyticsEventStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AnalyticsEventStoreManager {
    private static final Log log = LogFactory.getLog(AnalyticsEventStoreManager.class);
    private static AnalyticsEventStoreManager instance = new AnalyticsEventStoreManager();
    private Map<Integer, Set<AnalyticsEventStore>> tenantEventStoreMap = new HashMap<Integer, Set<AnalyticsEventStore>>();

    private AnalyticsEventStoreManager() {
    }

    public static AnalyticsEventStoreManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventStoreConfiguration(int tenantId, AnalyticsEventStore analyticsEventStore) throws AnalyticsEventStoreException {
        Set<AnalyticsEventStore> analyticsEventStoreList = this.tenantEventStoreMap.get(tenantId);
        if (analyticsEventStoreList == null) {
            AnalyticsEventStoreManager analyticsEventStoreManager = this;
            synchronized (analyticsEventStoreManager) {
                analyticsEventStoreList = this.tenantEventStoreMap.get(tenantId);
                if (analyticsEventStoreList == null) {
                    analyticsEventStoreList = new LinkedHashSet<AnalyticsEventStore>();
                    this.tenantEventStoreMap.put(tenantId, analyticsEventStoreList);
                }
            }
        }
        analyticsEventStoreList.add(analyticsEventStore);
    }

    public void saveEventStoreConfiguration(int tenantId, AnalyticsEventStore eventStore) throws AnalyticsEventStoreException {
        String fileName = MultitenantUtils.getAxis2RepositoryPath((int)tenantId) + "eventsink" + File.separator + eventStore.getName() + ".xml";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AnalyticsEventStore.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.marshal((Object)eventStore, new File(fileName));
        }
        catch (JAXBException e) {
            throw new AnalyticsEventStoreException("Error while marshalling the analytics event store configuration at file : " + fileName, (Exception)((Object)e));
        }
    }

    public void deleteEventStoreConfiguration(int tenantId, String eventStoreName) {
        File eventStoreFile = new File(MultitenantUtils.getAxis2RepositoryPath((int)tenantId) + "eventsink" + File.separator + eventStoreName + ".xml");
        if (eventStoreFile.exists() && !eventStoreFile.delete()) {
            log.warn((Object)("Unable to successfully delete the file : " + eventStoreFile.getName() + " for tenant id : " + tenantId));
        }
    }

    public AnalyticsEventStore getAnalyticsEventStore(File configFile) throws AnalyticsEventStoreException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnalyticsEventStore.class});
            Unmarshaller un = context.createUnmarshaller();
            return (AnalyticsEventStore)un.unmarshal(configFile);
        }
        catch (JAXBException e) {
            throw new AnalyticsEventStoreException("Error while unmarshalling the configuration from file : " + configFile.getPath(), (Exception)((Object)e));
        }
    }

    public AnalyticsEventStore getAnalyticsEventStore(int tenantId, String eventStoreName) {
        Set<AnalyticsEventStore> eventStoreConfigurations = this.tenantEventStoreMap.get(tenantId);
        if (eventStoreConfigurations != null) {
            for (AnalyticsEventStore configuration : eventStoreConfigurations) {
                if (!configuration.getName().equalsIgnoreCase(eventStoreName)) continue;
                return configuration;
            }
        }
        return null;
    }

    public AnalyticsEventStore removeEventStoreConfiguration(int tenantId, String eventStoreName) {
        Set<AnalyticsEventStore> analyticsEventStoreList = this.tenantEventStoreMap.get(tenantId);
        if (analyticsEventStoreList != null) {
            for (AnalyticsEventStore analyticsEventStore : analyticsEventStoreList) {
                if (!analyticsEventStore.getName().equalsIgnoreCase(eventStoreName)) continue;
                analyticsEventStoreList.remove(analyticsEventStore);
                return analyticsEventStore;
            }
        }
        return null;
    }
}

