/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventStoreDeployer;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.utils.CarbonUtils;

public class AnalyticsEventSinkServerStartupObserver
implements ServerStartupObserver {
    private static Log log = LogFactory.getLog(AnalyticsEventSinkServerStartupObserver.class);
    private static AnalyticsEventSinkServerStartupObserver instance = new AnalyticsEventSinkServerStartupObserver();
    private AtomicBoolean started = new AtomicBoolean();

    private AnalyticsEventSinkServerStartupObserver() {
    }

    public static AnalyticsEventSinkServerStartupObserver getInstance() {
        return instance;
    }

    public void completingServerStartup() {
    }

    public void completedServerStartup() {
        PausedDeploymentHandler pausedDeploymentHandler = new PausedDeploymentHandler();
        pausedDeploymentHandler.start();
    }

    public boolean isServerStarted() {
        return this.started.get();
    }

    private class PausedDeploymentHandler
    extends Thread {
        private PausedDeploymentHandler() {
        }

        @Override
        public void run() {
            try {
                AnalyticsEventStoreDeployer deployer = (AnalyticsEventStoreDeployer)CarbonUtils.getDeployer((String)AnalyticsEventStoreDeployer.class.getName());
                if (AnalyticsEventStoreDeployer.getPausedDeployments() != null) {
                    List<DeploymentFileData> pausedDeployment = AnalyticsEventStoreDeployer.getPausedDeployments();
                    AnalyticsEventSinkServerStartupObserver.this.started.set(true);
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                    for (DeploymentFileData deploymentFileData : pausedDeployment) {
                        try {
                            deployer.deploy(deploymentFileData);
                        }
                        catch (DeploymentException e) {
                            log.error((Object)("Error while  deploying analytics event store the file : " + deploymentFileData.getName()), (Throwable)e);
                        }
                    }
                    AnalyticsEventStoreDeployer.clearPausedDeployments();
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
            catch (CarbonException e) {
                log.error((Object)"Error when getting the deployer for evn store to proceed the initialization of deployments. ", (Throwable)e);
            }
        }
    }
}

