/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.analytics.api.AnalyticsDataAPI;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventSinkService;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventSinkServiceImpl;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventStoreCAppDeployer;
import org.wso2.carbon.analytics.eventsink.internal.AnalyticsDSConnector;
import org.wso2.carbon.analytics.eventsink.internal.AnalyticsEventSinkConfiguration;
import org.wso2.carbon.analytics.eventsink.internal.AnalyticsEventSinkServerStartupObserver;
import org.wso2.carbon.analytics.eventsink.internal.CarbonEventSinkManagementService;
import org.wso2.carbon.analytics.eventsink.internal.jmx.EventReceiverCounter;
import org.wso2.carbon.analytics.eventsink.internal.jmx.QueueEventBufferSizeCalculator;
import org.wso2.carbon.analytics.eventsink.internal.util.ServiceHolder;
import org.wso2.carbon.analytics.eventsink.subscriber.AnalyticsEventStreamListener;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.event.processor.manager.core.EventManagementService;
import org.wso2.carbon.event.processor.manager.core.Manager;
import org.wso2.carbon.event.stream.core.EventStreamListener;
import org.wso2.carbon.event.stream.core.EventStreamService;
import org.wso2.carbon.utils.CarbonUtils;

public class AnalyticsEventSinkComponent {
    private static Log log = LogFactory.getLog(AnalyticsEventSinkComponent.class);

    protected void activate(ComponentContext componentContext) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Started the Analytics Event Sink component");
            }
            ServiceHolder.setAnalyticsEventSinkService(new AnalyticsEventSinkServiceImpl());
            ServiceHolder.setEventPublisherManagementService(new CarbonEventSinkManagementService());
            componentContext.getBundleContext().registerService(EventStreamListener.class.getName(), (Object)ServiceHolder.getAnalyticsEventStreamListener(), null);
            componentContext.getBundleContext().registerService(AnalyticsEventSinkService.class.getName(), (Object)ServiceHolder.getAnalyticsEventSinkService(), null);
            componentContext.getBundleContext().registerService(ServerStartupObserver.class.getName(), (Object)AnalyticsEventSinkServerStartupObserver.getInstance(), null);
            componentContext.getBundleContext().registerService(AppDeploymentHandler.class.getName(), (Object)new AnalyticsEventStoreCAppDeployer(), null);
            ServiceHolder.getEventManagementService().subscribe((Manager)ServiceHolder.getEventPublisherManagementService());
            this.loadAnalyticsEventSinkConfiguration();
            ServiceHolder.setAnalyticsDSConnector(new AnalyticsDSConnector());
        }
        catch (Exception e) {
            log.error((Object)"Error while activating the AnalyticsEventSinkComponent.", (Throwable)e);
        }
        try {
            String queueBufferSize;
            ObjectName queueBufferMbean;
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            String eventCounterObject = "org.wso2.carbon:00=analytics,01=EVENT_PERSISTENCE_COUNTER";
            ObjectName eventCounterMbean = new ObjectName(eventCounterObject);
            if (!platformMBeanServer.isRegistered(eventCounterMbean)) {
                EventReceiverCounter counter = new EventReceiverCounter();
                platformMBeanServer.registerMBean(counter, eventCounterMbean);
            }
            if (!platformMBeanServer.isRegistered(queueBufferMbean = new ObjectName(queueBufferSize = "org.wso2.carbon:00=analytics,01=RECEIVER_REMAINING_PERSISTENCE_QUEUE_BUFFER_SIZE_IN_BYTES"))) {
                QueueEventBufferSizeCalculator counter = new QueueEventBufferSizeCalculator();
                platformMBeanServer.registerMBean(counter, queueBufferMbean);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to create EventCounter stat MBean: " + e.getMessage()), (Throwable)e);
        }
    }

    private void loadAnalyticsEventSinkConfiguration() {
        File analyticsConfFile = new File(CarbonUtils.getCarbonConfigDirPath() + File.separator + "analytics" + File.separator + "analytics-eventsink-config.xml");
        if (analyticsConfFile.exists()) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AnalyticsEventSinkConfiguration.class});
                Unmarshaller un = context.createUnmarshaller();
                ServiceHolder.setAnalyticsEventSinkConfiguration((AnalyticsEventSinkConfiguration)un.unmarshal(analyticsConfFile));
            }
            catch (JAXBException e) {
                log.error((Object)("Error while unmarshalling the file : " + analyticsConfFile.getName() + ". Therefore getting the " + "default configuration."), (Throwable)e);
                ServiceHolder.setAnalyticsEventSinkConfiguration(new AnalyticsEventSinkConfiguration());
            }
        } else {
            ServiceHolder.setAnalyticsEventSinkConfiguration(new AnalyticsEventSinkConfiguration());
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopped AnalyticsEventSink component");
        }
    }

    protected void setStreamDefinitionStoreService(AbstractStreamDefinitionStore abstractStreamDefinitionStore) {
        ServiceHolder.setStreamDefinitionStoreService(abstractStreamDefinitionStore);
    }

    protected void unsetStreamDefinitionStoreService(AbstractStreamDefinitionStore abstractStreamDefinitionStore) {
        ServiceHolder.setStreamDefinitionStoreService(null);
    }

    protected void setEventStreamService(EventStreamService eventStreamService) {
        ServiceHolder.setAnalyticsEventStreamListener(new AnalyticsEventStreamListener());
        ServiceHolder.setEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        ServiceHolder.setEventStreamService(null);
    }

    protected void setAnalyticsDataAPI(AnalyticsDataAPI analyticsDataAPI) {
        ServiceHolder.setAnalyticsDataAPI(analyticsDataAPI);
    }

    protected void unsetAnalyticsDataAPI(AnalyticsDataAPI analyticsDataAPI) {
        ServiceHolder.setAnalyticsDataAPI(null);
    }

    protected void setEventManagementService(EventManagementService eventManagementService) {
        ServiceHolder.setEventManagementService(eventManagementService);
    }

    protected void unsetEventManagementService(EventManagementService eventManagementService) {
        ServiceHolder.setEventManagementService(null);
    }
}

