/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink.internal;

import com.google.gson.Gson;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.datasource.commons.ColumnDefinition;
import org.wso2.carbon.analytics.datasource.commons.Record;
import org.wso2.carbon.analytics.datasource.commons.exception.AnalyticsException;
import org.wso2.carbon.analytics.datasource.core.util.GenericUtils;
import org.wso2.carbon.analytics.eventsink.internal.jmx.EventCounter;
import org.wso2.carbon.analytics.eventsink.internal.util.AnalyticsEventSinkUtil;
import org.wso2.carbon.analytics.eventsink.internal.util.ServiceHolder;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.core.definitionstore.AbstractStreamDefinitionStore;
import org.wso2.carbon.databridge.core.exception.StreamDefinitionStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class AnalyticsDSConnector {
    private static final Log log = LogFactory.getLog(AnalyticsDSConnector.class);
    private Gson gson = new Gson();
    private AtomicInteger recordsPersisted;
    private AtomicInteger totalRecordCounter;
    private long startTime;
    private boolean isProfilePersistence;
    private int cutoff = 100000;

    public AnalyticsDSConnector() {
        String profileReceiver = System.getProperty("profilePersistence");
        if (profileReceiver != null && profileReceiver.equalsIgnoreCase("true")) {
            this.isProfilePersistence = true;
            this.recordsPersisted = new AtomicInteger();
            this.totalRecordCounter = new AtomicInteger();
            this.startTime = 0L;
            String cutoffInput = System.getProperty("persistenceStatsCutoff");
            if (cutoffInput != null && StringUtils.isNumeric((CharSequence)cutoffInput)) {
                this.cutoff = Integer.parseInt(cutoffInput);
            }
        }
    }

    public void insertEvents(int tenantId, List<Event> events) throws StreamDefinitionStoreException, AnalyticsException {
        if (!ServiceHolder.getEventPublisherManagementService().isDrop()) {
            List<Record> records = this.convertEventsToRecord(tenantId, events);
            EventCounter.incrementAndGet(events.size());
            this.startTimeMeasurement();
            ServiceHolder.getAnalyticsDataAPI().put(records);
            this.endTimeMeasurement(records.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTimeMeasurement(int recordCount) {
        if (this.isProfilePersistence) {
            this.recordsPersisted.addAndGet(recordCount);
            if (this.recordsPersisted.get() > this.cutoff) {
                AnalyticsDSConnector analyticsDSConnector = this;
                synchronized (analyticsDSConnector) {
                    if (this.recordsPersisted.get() > this.cutoff) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        Date date = new Date();
                        long endTime = System.currentTimeMillis();
                        int currentBatchSize = this.recordsPersisted.getAndSet(0);
                        this.totalRecordCounter.addAndGet(currentBatchSize);
                        String line = "[" + dateFormat.format(date) + "] # of records : " + currentBatchSize + " start timestamp : " + this.startTime + " end time stamp : " + endTime + " Throughput is (records / sec) : " + (long)(currentBatchSize * 1000) / (endTime - this.startTime) + " Total Record Count : " + this.totalRecordCounter + " \n";
                        File file = new File(CarbonUtils.getCarbonHome() + File.separator + "persistence-perf.txt");
                        if (!file.exists()) {
                            log.info((Object)("Creating the data persistence performance measurement log at : " + file.getAbsolutePath()));
                        }
                        try {
                            this.appendToFile(IOUtils.toInputStream((String)line), file);
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        this.startTime = 0L;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToFile(InputStream in, File f) throws IOException {
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(f, true));
            IOUtils.copy((InputStream)in, (OutputStream)stream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeMeasurement() {
        if (this.isProfilePersistence && this.startTime == 0L) {
            AnalyticsDSConnector analyticsDSConnector = this;
            synchronized (analyticsDSConnector) {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
            }
        }
    }

    private List<Record> convertEventsToRecord(int tenantId, List<Event> events) throws StreamDefinitionStoreException, AnalyticsException {
        ArrayList<Record> records = new ArrayList<Record>(events.size());
        AbstractStreamDefinitionStore streamDefinitionStore = ServiceHolder.getStreamDefinitionStoreService();
        if (streamDefinitionStore == null) {
            throw new AnalyticsException("Stream Definition store is not available. dropping Event");
        }
        for (Event event : events) {
            long timestamp = System.currentTimeMillis();
            StreamDefinition streamDefinition = streamDefinitionStore.getStreamDefinition(event.getStreamId(), tenantId);
            String tableName = AnalyticsEventSinkUtil.generateAnalyticsTableName(streamDefinition.getName());
            AnalyticsSchema analyticsSchema = ServiceHolder.getAnalyticsDataAPI().getTableSchema(tenantId, tableName);
            HashMap<String, Object> eventAttributes = new HashMap<String, Object>();
            this.populateCommonAttributes(streamDefinition, analyticsSchema, eventAttributes);
            this.populateTypedAttributes(analyticsSchema, "meta", streamDefinition.getMetaData(), event.getMetaData(), eventAttributes);
            this.populateTypedAttributes(analyticsSchema, "correlation", streamDefinition.getCorrelationData(), event.getCorrelationData(), eventAttributes);
            Long payloadTimestamp = this.populateTypedPayloadAttributes(analyticsSchema, null, streamDefinition.getPayloadData(), event.getPayloadData(), eventAttributes);
            if (payloadTimestamp != null) {
                timestamp = payloadTimestamp;
            } else if (event.getTimeStamp() != 0L) {
                timestamp = event.getTimeStamp();
            }
            if (event.getArbitraryDataMap() != null && !event.getArbitraryDataMap().isEmpty()) {
                for (String attributeName : event.getArbitraryDataMap().keySet()) {
                    String attributeKey = "_" + attributeName;
                    eventAttributes.put(attributeKey, this.getRecordValue(analyticsSchema, attributeKey, event.getArbitraryDataMap().get(attributeName), true));
                }
            }
            Record record = new Record(tenantId, tableName, eventAttributes, timestamp);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Record being added: " + record));
            }
            records.add(record);
        }
        return records;
    }

    private void populateTypedAttributes(AnalyticsSchema schema, String type, List<Attribute> attributes, Object[] values, Map<String, Object> eventAttribute) throws AnalyticsException {
        if (attributes == null) {
            return;
        }
        int iteration = 0;
        for (Attribute attribute : attributes) {
            String attributeKey = this.getAttributeKey(type, attribute.getName());
            Object recordValue = this.getRecordValue(schema, attributeKey, values[iteration], false);
            if (recordValue != null) {
                eventAttribute.put(attributeKey, recordValue);
            }
            ++iteration;
        }
    }

    private Long populateTypedPayloadAttributes(AnalyticsSchema schema, String type, List<Attribute> attributes, Object[] values, Map<String, Object> eventAttribute) throws AnalyticsException {
        Long timestamp = null;
        if (attributes == null) {
            return null;
        }
        int iteration = 0;
        for (Attribute attribute : attributes) {
            String attributeKey;
            Object recordValue;
            if ("_timestamp".equals(attribute.getName())) {
                if (values[iteration] != null) {
                    timestamp = (Long)values[iteration];
                    continue;
                }
                log.error((Object)"Timestamp value is null.");
            }
            if ((recordValue = this.getRecordValue(schema, attributeKey = this.getAttributeKey(type, attribute.getName()), values[iteration], false)) != null) {
                eventAttribute.put(attributeKey, recordValue);
            }
            ++iteration;
        }
        return timestamp;
    }

    private String getAttributeKey(String type, String attributeName) {
        if (type == null) {
            return attributeName;
        }
        return type + "_" + attributeName;
    }

    private void populateCommonAttributes(StreamDefinition streamDefinition, AnalyticsSchema schema, Map<String, Object> eventAttributes) throws AnalyticsException {
        eventAttributes.put("_version", this.getRecordValue(schema, "_version", streamDefinition.getVersion(), true));
    }

    private Object getRecordValue(AnalyticsSchema schema, String fieldName, Object fieldValue, boolean mandatoryValue) throws AnalyticsException {
        ColumnDefinition columnDefinition = (ColumnDefinition)schema.getColumns().get(fieldName);
        if (columnDefinition != null) {
            if (fieldValue instanceof String) {
                String fieldStrValue = (String)fieldValue;
                switch (columnDefinition.getType()) {
                    case STRING: {
                        if (columnDefinition.isFacet()) {
                            try {
                                return StringUtils.join((Iterable)((Iterable)this.gson.fromJson(fieldStrValue, List.class)), (char)',');
                            }
                            catch (Exception e) {
                                return fieldStrValue;
                            }
                        }
                        return fieldStrValue;
                    }
                    case BINARY: {
                        return GenericUtils.serializeObject((Object)fieldStrValue);
                    }
                    case BOOLEAN: {
                        return Boolean.parseBoolean(fieldStrValue);
                    }
                    case DOUBLE: {
                        return Double.parseDouble(fieldStrValue);
                    }
                    case FLOAT: {
                        return Float.valueOf(Float.parseFloat(fieldStrValue));
                    }
                    case INTEGER: {
                        return Integer.parseInt(fieldStrValue);
                    }
                    case LONG: {
                        return Long.parseLong(fieldStrValue);
                    }
                    case FACET: {
                        return fieldStrValue;
                    }
                }
                return fieldValue;
            }
            return fieldValue;
        }
        if (mandatoryValue) {
            return fieldValue;
        }
        return null;
    }
}

