/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink;

import java.io.File;
import java.util.List;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventStoreDeployer;
import org.wso2.carbon.analytics.eventsink.exception.AnalyticsEventStoreDeploymentException;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.utils.CarbonUtils;

public class AnalyticsEventStoreCAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(AnalyticsEventStoreCAppDeployer.class);
    private static final String TYPE = "analytics/eventstore";

    public void deployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfiguration) throws DeploymentException {
        List artifacts = carbonApplication.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null || !TYPE.equals(artifact.getType())) continue;
            List files = artifact.getFiles();
            if (files.size() == 1) {
                String fileName = ((CappFile)files.get(0)).getName();
                String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
                try {
                    Deployer deployer = CarbonUtils.getDeployer((String)AnalyticsEventStoreDeployer.class.getName());
                    deployer.deploy(new DeploymentFileData(new File(artifactPath)));
                    artifact.setDeploymentStatus("Deployed");
                    continue;
                }
                catch (DeploymentException e) {
                    artifact.setDeploymentStatus("Failed");
                    throw e;
                }
                catch (CarbonException e) {
                    artifact.setDeploymentStatus("Failed");
                    String msg = "Error while getting the deployer instance for event store artifact. ";
                    log.error((Object)msg, (Throwable)e);
                    throw new AnalyticsEventStoreDeploymentException(msg, e);
                }
            }
            if (files.size() == 0) continue;
            log.error((Object)("Analytics Indices must have a single XML file to be deployed. But " + files.size() + " files found."));
        }
    }

    public void undeployArtifacts(CarbonApplication carbonApplication, AxisConfiguration axisConfiguration) throws DeploymentException {
        List artifacts = carbonApplication.getAppConfig().getApplicationArtifact().getDependencies();
        for (Artifact.Dependency dep : artifacts) {
            Artifact artifact = dep.getArtifact();
            if (artifact == null || !TYPE.equals(artifact.getType())) continue;
            List files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)("Analytics event store application must have a single analytics event store file. But " + files.size() + " files found."));
                continue;
            }
            if (!"Deployed".equals(artifact.getDeploymentStatus())) continue;
            String fileName = ((CappFile)artifact.getFiles().get(0)).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            try {
                Deployer deployer = CarbonUtils.getDeployer((String)AnalyticsEventStoreDeployer.class.getName());
                deployer.undeploy(artifactPath);
                artifact.setDeploymentStatus("Pending");
            }
            catch (DeploymentException e) {
                artifact.setDeploymentStatus("Failed");
                log.error((Object)("Error occurred while trying to undeploy : " + artifact.getName()));
            }
            catch (CarbonException e) {
                artifact.setDeploymentStatus("Failed");
                String msg = "Error while getting the deployer instance for event store artifact. ";
                log.error((Object)msg, (Throwable)e);
                throw new AnalyticsEventStoreDeploymentException(msg, e);
            }
        }
    }
}

