/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.analytics.eventsink;

import java.util.List;
import org.wso2.carbon.analytics.datasource.commons.AnalyticsSchema;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventSinkService;
import org.wso2.carbon.analytics.eventsink.AnalyticsEventStore;
import org.wso2.carbon.analytics.eventsink.exception.AnalyticsEventStoreException;
import org.wso2.carbon.analytics.eventsink.internal.AnalyticsEventStoreManager;
import org.wso2.carbon.analytics.eventsink.internal.util.AnalyticsEventSinkUtil;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;

public class AnalyticsEventSinkServiceImpl
implements AnalyticsEventSinkService {
    @Override
    public void putEventSink(int tenantId, String streamName, String version, AnalyticsSchema analyticsSchema, String recordStoreName) throws AnalyticsEventStoreException {
        this.putEventSinkWithSchemaMergeInfo(tenantId, streamName, version, analyticsSchema, recordStoreName, false);
    }

    @Override
    public void putEventSinkWithSchemaMergeInfo(int tenantId, String streamName, String version, AnalyticsSchema analyticsSchema, String recordStoreName, boolean isMergeSchema) throws AnalyticsEventStoreException {
        AnalyticsEventStore analyticsEventStore = AnalyticsEventSinkUtil.getAnalyticsEventStore(streamName, version, analyticsSchema, recordStoreName);
        analyticsEventStore.setMergeSchema(isMergeSchema);
        this.putEventStoreWithSchemaMerge(tenantId, analyticsEventStore);
    }

    @Override
    public void putEventStore(int tenantId, AnalyticsEventStore eventStore) throws AnalyticsEventStoreException {
        AnalyticsEventStoreManager.getInstance().saveEventStoreConfiguration(tenantId, eventStore);
    }

    @Override
    public void putEventStoreWithSchemaMerge(int tenantId, AnalyticsEventStore analyticsEventStore) throws AnalyticsEventStoreException {
        AnalyticsEventStore existingEventStore = AnalyticsEventStoreManager.getInstance().getAnalyticsEventStore(tenantId, analyticsEventStore.getName());
        if (existingEventStore != null) {
            if (existingEventStore.getRecordStore() == null) {
                if (analyticsEventStore.getRecordStore() != null) {
                    String streamIds = AnalyticsEventSinkUtil.getEventSources(analyticsEventStore.getEventSource().getStreamIds());
                    String errorDetail = streamIds == null ? "" : ". Event Source: " + streamIds;
                    throw new AnalyticsEventStoreException("Already event store is configured with primary record store, therefore unable to proceed with new event sink" + errorDetail);
                }
            } else {
                if (analyticsEventStore.getRecordStore() == null) {
                    String streamIds = AnalyticsEventSinkUtil.getEventSources(analyticsEventStore.getEventSource().getStreamIds());
                    String errorDetail = streamIds == null ? "" : ". Event Source: " + streamIds;
                    throw new AnalyticsEventStoreException("Already event store is configured with record store name : " + analyticsEventStore.getRecordStore() + "," + " therefore unable to proceed with new event sink with primary record store" + errorDetail);
                }
                if (!analyticsEventStore.getRecordStore().equals(existingEventStore.getRecordStore())) {
                    String streamIds = AnalyticsEventSinkUtil.getEventSources(analyticsEventStore.getEventSource().getStreamIds());
                    String errorDetail = streamIds == null ? "" : ". Event Source: " + streamIds;
                    throw new AnalyticsEventStoreException("Already event store is configured with record store name : " + analyticsEventStore.getRecordStore() + "," + " therefore unable to proceed with new event sink with record store :" + analyticsEventStore.getRecordStore() + errorDetail);
                }
            }
            List<String> streamIdList = analyticsEventStore.getEventSource().getStreamIds();
            for (String aStream : existingEventStore.getEventSource().getStreamIds()) {
                if (streamIdList.contains(aStream)) continue;
                streamIdList.add(aStream);
            }
        }
        this.putEventStore(tenantId, analyticsEventStore);
    }

    @Override
    public void removeEventSink(int tenantId, String streamName, String version) throws AnalyticsEventStoreException {
        String streamId = DataBridgeCommonsUtils.generateStreamId((String)streamName, (String)version);
        String eventStoreName = AnalyticsEventSinkUtil.generateAnalyticsTableName(streamName);
        AnalyticsEventStore existingEventStore = AnalyticsEventStoreManager.getInstance().getAnalyticsEventStore(tenantId, eventStoreName);
        if (existingEventStore != null && existingEventStore.getEventSource().getStreamIds().contains(streamId)) {
            if (existingEventStore.getEventSource().getStreamIds().size() == 1) {
                AnalyticsEventStoreManager.getInstance().deleteEventStoreConfiguration(tenantId, eventStoreName);
            } else {
                AnalyticsEventStore newAnalyticsEventSink = AnalyticsEventSinkUtil.copyAnalyticsEventStore(existingEventStore);
                newAnalyticsEventSink.getEventSource().getStreamIds().remove(streamId);
                AnalyticsEventStoreManager.getInstance().saveEventStoreConfiguration(tenantId, newAnalyticsEventSink);
            }
        }
    }

    @Override
    public AnalyticsEventStore getEventStore(int tenantId, String streamName) {
        String eventStoreName = AnalyticsEventSinkUtil.generateAnalyticsTableName(streamName);
        return AnalyticsEventStoreManager.getInstance().getAnalyticsEventStore(tenantId, eventStoreName);
    }

    @Override
    public String generateAnalyticsTableName(String streamName) {
        return AnalyticsEventSinkUtil.generateAnalyticsTableName(streamName);
    }
}

