/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.thread;

import java.util.concurrent.Executor;
import java.util.function.Consumer;
import wiremock.org.eclipse.jetty.util.thread.SerializedInvoker;
import wiremock.org.slf4j.LoggerFactory;

public class SerializedExecutor
implements Executor {
    private final Executor _executor;
    private final SerializedInvoker _invoker;

    public SerializedExecutor() {
        this(Runnable::run);
    }

    public SerializedExecutor(Executor executor) {
        this._executor = executor;
        this._invoker = new SerializedInvoker(SerializedExecutor.class.getSimpleName(), executor){

            @Override
            protected void onError(Runnable task, Throwable t) {
                SerializedExecutor.this.onError(task, t);
            }
        };
    }

    protected void onError(Runnable task, Throwable t) {
        block3: {
            try {
                if (task instanceof ErrorHandlingTask) {
                    ((ErrorHandlingTask)task).accept(t);
                }
            }
            catch (Throwable x) {
                if (x == t) break block3;
                t.addSuppressed(x);
            }
        }
        LoggerFactory.getLogger(task.getClass()).error("Error", t);
    }

    @Override
    public void execute(Runnable task) {
        Runnable todo = this._invoker.offer(task);
        if (todo != null) {
            this._executor.execute(todo);
        }
    }

    public void execute(Runnable ... tasks) {
        Runnable todo = this._invoker.offer(tasks);
        if (todo != null) {
            this._executor.execute(todo);
        }
    }

    public static interface ErrorHandlingTask
    extends Runnable,
    Consumer<Throwable> {
    }
}

