/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.internal;

import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.PreEncodedHttpField;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ResponseHttpFields
extends HttpFields.Mutable.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHttpFields.class);
    private final AtomicBoolean _committed = new AtomicBoolean();

    public ResponseHttpFields() {
        super(HttpFields.build());
    }

    public HttpFields.Mutable getMutableHttpFields() {
        return this.getWrapped();
    }

    public boolean commit() {
        boolean committed = this._committed.compareAndSet(false, true);
        if (committed && LOG.isDebugEnabled()) {
            LOG.debug("{} committed", (Object)this);
        }
        return committed;
    }

    public boolean isCommitted() {
        return this._committed.get();
    }

    @Override
    public HttpField onAddField(HttpField field) {
        if (this.isCommitted()) {
            return null;
        }
        return super.onAddField(field);
    }

    @Override
    public boolean onRemoveField(HttpField field) {
        if (this.isCommitted()) {
            return false;
        }
        if (Persistent.isPersistent(field)) {
            throw new UnsupportedOperationException("Persistent field");
        }
        return true;
    }

    @Override
    public HttpField onReplaceField(HttpField oldField, HttpField newField) {
        if (this.isCommitted()) {
            return oldField;
        }
        if (oldField instanceof Persistent) {
            Persistent persistent = (Persistent)((Object)oldField);
            if (newField == null || !newField.isSameName(oldField)) {
                throw new UnsupportedOperationException("Persistent field");
            }
            newField = newField instanceof PreEncodedHttpField ? new PersistentPreEncodedHttpField(oldField.getHeader(), newField.getValue(), persistent.getOriginal()) : new PersistentHttpField(newField, persistent.getOriginal());
        }
        return newField;
    }

    public void recycle() {
        this._committed.set(false);
        super.clear();
    }

    @Override
    public HttpFields asImmutable() {
        return this._committed.get() ? this : this.getMutableHttpFields().asImmutable();
    }

    @Override
    public HttpFields.Mutable clear() {
        if (!this._committed.get()) {
            ListIterator<HttpField> iterator = this.getMutableHttpFields().listIterator(this.size());
            while (iterator.hasPrevious()) {
                HttpField field = iterator.previous();
                if (field instanceof Persistent) {
                    Persistent persistent = (Persistent)((Object)field);
                    iterator.set(persistent.getOriginal());
                    continue;
                }
                iterator.remove();
            }
        }
        return this;
    }

    public static interface Persistent {
        public static boolean isPersistent(HttpField field) {
            return field instanceof Persistent;
        }

        public HttpField getOriginal();
    }

    public static class PersistentPreEncodedHttpField
    extends PreEncodedHttpField
    implements Persistent {
        private final HttpField _original;

        public PersistentPreEncodedHttpField(HttpHeader header, String value) {
            this(header, value, (HttpField)null);
        }

        PersistentPreEncodedHttpField(HttpHeader header, String value, HttpField original) {
            super(header, value);
            this._original = original == null ? this : original;
        }

        @Override
        public HttpField getOriginal() {
            return this._original;
        }
    }

    public static class PersistentHttpField
    extends HttpField
    implements Persistent {
        private final HttpField _field;
        private final HttpField _original;

        public PersistentHttpField(HttpField field) {
            this(field, null);
        }

        PersistentHttpField(HttpField field, HttpField original) {
            super(field.getHeader(), field.getName(), field.getValue());
            this._field = field;
            this._original = original == null ? this : original;
        }

        @Override
        public int getIntValue() {
            return this._field.getIntValue();
        }

        @Override
        public long getLongValue() {
            return this._field.getIntValue();
        }

        @Override
        public HttpField getOriginal() {
            return this._original;
        }
    }
}

