/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.Header;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpMessage;
import wiremock.org.apache.hc.core5.http.HttpRequest;
import wiremock.org.apache.hc.core5.http.HttpResponse;
import wiremock.org.apache.hc.core5.http.HttpVersion;
import wiremock.org.apache.hc.core5.http.Method;
import wiremock.org.apache.hc.core5.http.ProtocolException;
import wiremock.org.apache.hc.core5.http.impl.BasicHttpConnectionMetrics;
import wiremock.org.apache.hc.core5.http.impl.IncomingEntityDetails;
import wiremock.org.apache.hc.core5.http.impl.ServerSupport;
import wiremock.org.apache.hc.core5.http.impl.nio.MessageState;
import wiremock.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import wiremock.org.apache.hc.core5.http.nio.AsyncPushProducer;
import wiremock.org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import wiremock.org.apache.hc.core5.http.nio.DataStreamChannel;
import wiremock.org.apache.hc.core5.http.nio.HandlerFactory;
import wiremock.org.apache.hc.core5.http.nio.ResponseChannel;
import wiremock.org.apache.hc.core5.http.nio.support.BasicResponseProducer;
import wiremock.org.apache.hc.core5.http.nio.support.ImmediateResponseExchangeHandler;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.http.protocol.HttpCoreContext;
import wiremock.org.apache.hc.core5.http.protocol.HttpProcessor;
import wiremock.org.apache.hc.core5.http2.H2ConnectionException;
import wiremock.org.apache.hc.core5.http2.H2Error;
import wiremock.org.apache.hc.core5.http2.H2StreamResetException;
import wiremock.org.apache.hc.core5.http2.impl.DefaultH2RequestConverter;
import wiremock.org.apache.hc.core5.http2.impl.DefaultH2ResponseConverter;
import wiremock.org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import wiremock.org.apache.hc.core5.http2.impl.nio.H2StreamHandler;
import wiremock.org.apache.hc.core5.util.Asserts;

class ServerH2StreamHandler
implements H2StreamHandler {
    private final H2StreamChannel outputChannel;
    private final DataStreamChannel dataChannel;
    private final ResponseChannel responseChannel;
    private final HttpProcessor httpProcessor;
    private final BasicHttpConnectionMetrics connMetrics;
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;
    private final HttpCoreContext context;
    private final AtomicReference<MessageState> requestState;
    private final AtomicReference<MessageState> responseState;
    private final AtomicBoolean responseCommitted;
    private final AtomicBoolean failed;
    private final AtomicBoolean done;
    private volatile AsyncServerExchangeHandler exchangeHandler;
    private volatile HttpRequest receivedRequest;

    ServerH2StreamHandler(final H2StreamChannel outputChannel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics connMetrics, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, HttpCoreContext context) {
        this.outputChannel = outputChannel;
        this.dataChannel = new DataStreamChannel(){

            @Override
            public void requestOutput() {
                outputChannel.requestOutput();
            }

            @Override
            public int write(ByteBuffer src) throws IOException {
                return outputChannel.write(src);
            }

            @Override
            public void endStream(List<? extends Header> trailers) throws IOException {
                outputChannel.endStream(trailers);
                ServerH2StreamHandler.this.responseState.set(MessageState.COMPLETE);
            }

            @Override
            public void endStream() throws IOException {
                outputChannel.endStream();
                ServerH2StreamHandler.this.responseState.set(MessageState.COMPLETE);
            }
        };
        this.responseChannel = new ResponseChannel(){

            @Override
            public void sendInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
                ServerH2StreamHandler.this.commitInformation(response);
            }

            @Override
            public void sendResponse(HttpResponse response, EntityDetails responseEntityDetails, HttpContext httpContext) throws HttpException, IOException {
                ServerH2StreamHandler.this.commitResponse(response, responseEntityDetails);
            }

            @Override
            public void pushPromise(HttpRequest promise, AsyncPushProducer pushProducer, HttpContext httpContext) throws HttpException, IOException {
                ServerH2StreamHandler.this.commitPromise(promise, pushProducer);
            }
        };
        this.httpProcessor = httpProcessor;
        this.connMetrics = connMetrics;
        this.exchangeHandlerFactory = exchangeHandlerFactory;
        this.context = context;
        this.responseCommitted = new AtomicBoolean();
        this.failed = new AtomicBoolean();
        this.done = new AtomicBoolean();
        this.requestState = new AtomicReference<MessageState>(MessageState.HEADERS);
        this.responseState = new AtomicReference<MessageState>(MessageState.IDLE);
    }

    @Override
    public HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return null;
    }

    private void commitInformation(HttpResponse response) throws IOException, HttpException {
        if (this.responseCommitted.get()) {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Response already committed");
        }
        int status = response.getCode();
        if (status < 100 || status >= 200) {
            throw new HttpException("Invalid intermediate response: " + status);
        }
        List<Header> responseHeaders = DefaultH2ResponseConverter.INSTANCE.convert(response);
        this.outputChannel.submit(responseHeaders, false);
    }

    private void commitResponse(HttpResponse response, EntityDetails responseEntityDetails) throws HttpException, IOException {
        if (this.responseCommitted.compareAndSet(false, true)) {
            boolean endStream;
            int status = response.getCode();
            if (status < 200) {
                throw new HttpException("Invalid response: " + status);
            }
            this.context.setResponse(response);
            this.httpProcessor.process(response, responseEntityDetails, (HttpContext)this.context);
            List<Header> responseHeaders = DefaultH2ResponseConverter.INSTANCE.convert(response);
            boolean bl = endStream = responseEntityDetails == null || this.receivedRequest != null && Method.HEAD.isSame(this.receivedRequest.getMethod());
            if (endStream) {
                this.responseState.set(MessageState.COMPLETE);
                this.outputChannel.submit(responseHeaders, endStream);
                this.connMetrics.incrementResponseCount();
            } else {
                this.outputChannel.submit(responseHeaders, endStream);
                this.connMetrics.incrementResponseCount();
                this.exchangeHandler.produce(this.outputChannel);
                if (this.responseState.compareAndSet(MessageState.IDLE, MessageState.BODY)) {
                    this.outputChannel.requestOutput();
                }
            }
        } else {
            throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Response already committed");
        }
    }

    private void commitPromise(HttpRequest promise, AsyncPushProducer pushProducer) throws HttpException, IOException {
        this.httpProcessor.process(promise, null, (HttpContext)this.context);
        List<Header> promiseHeaders = DefaultH2RequestConverter.INSTANCE.convert(promise);
        this.outputChannel.push(promiseHeaders, pushProducer);
        this.connMetrics.incrementRequestCount();
    }

    @Override
    public void consumePromise(List<Header> headers) throws HttpException, IOException {
        throw new ProtocolException("Unexpected message promise");
    }

    @Override
    public void consumeHeader(List<Header> headers, boolean endStream) throws HttpException, IOException {
        if (this.done.get()) {
            throw new ProtocolException("Unexpected message headers");
        }
        switch (this.requestState.get()) {
            case HEADERS: {
                AsyncServerExchangeHandler handler;
                this.requestState.set(endStream ? MessageState.COMPLETE : MessageState.BODY);
                HttpMessage request = DefaultH2RequestConverter.INSTANCE.convert((List)headers);
                IncomingEntityDetails requestEntityDetails = endStream ? null : new IncomingEntityDetails(request, -1L);
                try {
                    handler = this.exchangeHandlerFactory != null ? this.exchangeHandlerFactory.create((HttpRequest)request, this.context) : null;
                }
                catch (ProtocolException ex) {
                    throw new H2StreamResetException(H2Error.PROTOCOL_ERROR, ex.getMessage());
                }
                if (handler == null) {
                    throw new H2StreamResetException(H2Error.REFUSED_STREAM, "Stream refused");
                }
                this.exchangeHandler = handler;
                this.context.setProtocolVersion(HttpVersion.HTTP_2);
                this.context.setRequest((HttpRequest)request);
                try {
                    this.httpProcessor.process((HttpRequest)request, (EntityDetails)requestEntityDetails, (HttpContext)this.context);
                    this.connMetrics.incrementRequestCount();
                    this.receivedRequest = request;
                    this.exchangeHandler.handleRequest((HttpRequest)request, requestEntityDetails, this.responseChannel, this.context);
                    break;
                }
                catch (HttpException ex) {
                    if (!this.responseCommitted.get()) {
                        BasicResponseProducer responseProducer = new BasicResponseProducer(ServerSupport.toStatusCode(ex), ServerSupport.toErrorMessage(ex));
                        this.exchangeHandler = new ImmediateResponseExchangeHandler(responseProducer);
                        this.exchangeHandler.handleRequest((HttpRequest)request, requestEntityDetails, this.responseChannel, this.context);
                        break;
                    }
                    throw ex;
                }
            }
            case BODY: {
                this.responseState.set(MessageState.COMPLETE);
                this.exchangeHandler.streamEnd(headers);
                break;
            }
            default: {
                throw new ProtocolException("Unexpected message headers");
            }
        }
    }

    @Override
    public void updateInputCapacity() throws IOException {
        Asserts.notNull(this.exchangeHandler, "Exchange handler");
        this.exchangeHandler.updateCapacity(this.outputChannel);
    }

    @Override
    public void consumeData(ByteBuffer src, boolean endStream) throws HttpException, IOException {
        if (this.done.get() || this.requestState.get() != MessageState.BODY) {
            throw new ProtocolException("Unexpected message data");
        }
        Asserts.notNull(this.exchangeHandler, "Exchange handler");
        if (src != null) {
            this.exchangeHandler.consume(src);
        }
        if (endStream) {
            this.requestState.set(MessageState.COMPLETE);
            this.exchangeHandler.streamEnd(null);
        }
    }

    @Override
    public boolean isOutputReady() {
        return this.responseState.get() == MessageState.BODY && this.exchangeHandler != null && this.exchangeHandler.available() > 0;
    }

    @Override
    public void produceOutput() throws HttpException, IOException {
        if (this.responseState.get() == MessageState.BODY) {
            Asserts.notNull(this.exchangeHandler, "Exchange handler");
            this.exchangeHandler.produce(this.dataChannel);
        }
    }

    @Override
    public void handle(HttpException ex, boolean endStream) throws HttpException, IOException {
        if (this.done.get()) {
            throw ex;
        }
        switch (this.requestState.get()) {
            case HEADERS: {
                this.requestState.set(endStream ? MessageState.COMPLETE : MessageState.BODY);
                if (!this.responseCommitted.get()) {
                    BasicResponseProducer responseProducer = new BasicResponseProducer(ServerSupport.toStatusCode(ex), ServerSupport.toErrorMessage(ex));
                    this.exchangeHandler = new ImmediateResponseExchangeHandler(responseProducer);
                    this.exchangeHandler.handleRequest(null, null, this.responseChannel, this.context);
                    break;
                }
                throw ex;
            }
            case BODY: {
                this.responseState.set(MessageState.COMPLETE);
            }
            default: {
                throw ex;
            }
        }
    }

    @Override
    public void failed(Exception cause) {
        try {
            if (this.failed.compareAndSet(false, true) && this.exchangeHandler != null) {
                this.exchangeHandler.failed(cause);
            }
        }
        finally {
            this.releaseResources();
        }
    }

    @Override
    public void releaseResources() {
        if (this.done.compareAndSet(false, true)) {
            this.requestState.set(MessageState.COMPLETE);
            this.responseState.set(MessageState.COMPLETE);
            if (this.exchangeHandler != null) {
                this.exchangeHandler.releaseResources();
            }
        }
    }

    public String toString() {
        return "[requestState=" + (Object)((Object)this.requestState.get()) + ", responseState=" + (Object)((Object)this.responseState.get()) + ']';
    }
}

