/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ScenarioProcessor {
    ScenarioProcessor() {
    }

    void putRepeatedRequestsInScenarios(List<StubMapping> stubMappings) {
        Map stubsGroupedByRequest = stubMappings.stream().collect(Collectors.groupingBy(StubMapping::getRequest, LinkedHashMap::new, Collectors.toCollection(LinkedList::new)));
        Map groupsWithMoreThanOneStub = stubsGroupedByRequest.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (entry1, entry2) -> entry1, LinkedHashMap::new));
        int scenarioIndex = 0;
        for (Map.Entry entry3 : groupsWithMoreThanOneStub.entrySet()) {
            LinkedList<StubMapping> stubsInScenario = new LinkedList<StubMapping>((Collection)entry3.getValue());
            Collections.reverse(stubsInScenario);
            this.putStubsInScenario(++scenarioIndex, stubsInScenario);
        }
    }

    private void putStubsInScenario(int scenarioIndex, List<StubMapping> stubMappings) {
        StubMapping firstScenario = stubMappings.get(0);
        String scenarioName = "scenario-" + scenarioIndex + "-" + Urls.urlToPathParts(URI.create(ParameterUtils.getFirstNonNull(firstScenario.getRequest().getUrl(), firstScenario.getRequest().getUrlPath())));
        int count = 1;
        for (StubMapping stub : stubMappings) {
            stub.setScenarioName(scenarioName);
            if (count == 1) {
                stub.setRequiredScenarioState("Started");
            } else {
                stub.setRequiredScenarioState(scenarioName + "-" + count);
            }
            if (count < stubMappings.size()) {
                stub.setNewScenarioState(scenarioName + "-" + (count + 1));
            }
            ++count;
        }
    }
}

