/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Extensions;
import com.github.tomakehurst.wiremock.extension.StubMappingTransformer;
import com.github.tomakehurst.wiremock.recording.NotRecordingException;
import com.github.tomakehurst.wiremock.recording.ProxiedServeEventFilters;
import com.github.tomakehurst.wiremock.recording.RecordError;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecorderState;
import com.github.tomakehurst.wiremock.recording.RecordingStatus;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingGenerator;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingPostProcessor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.github.tomakehurst.wiremock.store.RecorderStateStore;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Recorder {
    private final Admin admin;
    private final Extensions extensions;
    private final BlobStore filesBlobStore;
    private final RecorderStateStore stateStore;

    public Recorder(Admin admin, Extensions extensions, BlobStore filesBlobStore, RecorderStateStore stateStore) {
        this.admin = admin;
        this.extensions = extensions;
        this.filesBlobStore = filesBlobStore;
        this.stateStore = stateStore;
    }

    public synchronized void startRecording(RecordSpec spec) {
        List<ServeEvent> serveEvents;
        RecorderState state = this.stateStore.get();
        if (state.getStatus() == RecordingStatus.Recording) {
            return;
        }
        StubMapping proxyMapping = null;
        if (spec.getTargetBaseUrl() != null && !spec.getTargetBaseUrl().isEmpty()) {
            proxyMapping = WireMock.proxyAllTo(spec.getTargetBaseUrl()).build();
            this.admin.addStubMapping(proxyMapping);
        }
        UUID initialId = (serveEvents = this.admin.getServeEvents().getServeEvents()).isEmpty() ? null : serveEvents.get(0).getId();
        state = state.start(initialId, proxyMapping, spec);
        this.stateStore.set(state);
        LocalNotifier.notifier().info("Started recording with record spec:\n" + Json.write(spec));
    }

    public synchronized SnapshotRecordResult stopRecording() {
        RecorderState state = this.stateStore.get();
        if (state.getStatus() != RecordingStatus.Recording) {
            throw new NotRecordingException();
        }
        List<ServeEvent> serveEvents = this.admin.getServeEvents().getServeEvents();
        UUID lastId = serveEvents.isEmpty() ? null : serveEvents.get(0).getId();
        state = state.stop(lastId);
        this.stateStore.set(state);
        if (state.getProxyMapping() != null) {
            this.admin.removeStubMapping(state.getProxyMapping());
        }
        if (serveEvents.isEmpty()) {
            return SnapshotRecordResult.empty();
        }
        int startIndex = state.getStartingServeEventId() == null ? serveEvents.size() : ParameterUtils.indexOf(serveEvents, Recorder.withId(state.getStartingServeEventId()));
        int endIndex = ParameterUtils.indexOf(serveEvents, Recorder.withId(state.getFinishingServeEventId()));
        List<ServeEvent> eventsToSnapshot = serveEvents.subList(endIndex, startIndex);
        SnapshotRecordResult result = this.takeSnapshot(eventsToSnapshot, state.getSpec());
        LocalNotifier.notifier().info("Stopped recording. Stubs captured:\n" + Json.write(result.getStubMappings()));
        return result;
    }

    private static Predicate<ServeEvent> withId(UUID id) {
        return input -> input.getId().equals(id);
    }

    public SnapshotRecordResult takeSnapshot(List<ServeEvent> serveEvents, RecordSpec recordSpec) {
        Pair<List<RecordError>, List<StubMapping>> results = this.serveEventsToStubMappings(serveEvents, recordSpec.getFilters(), new SnapshotStubMappingGenerator(recordSpec.getCaptureHeaders(), recordSpec.getRequestBodyPatternFactory()), this.getStubMappingPostProcessor(recordSpec));
        for (StubMapping stubMapping : (List)results.b) {
            if (!recordSpec.shouldPersist()) continue;
            stubMapping.setPersistent(true);
        }
        this.admin.importStubs(new StubImport((List)results.b, StubImport.Options.DEFAULTS));
        return recordSpec.getOutputFormat().format((List)results.b, (List)results.a);
    }

    private Pair<List<RecordError>, List<StubMapping>> serveEventsToStubMappings(List<ServeEvent> serveEventsResult, ProxiedServeEventFilters serveEventFilters, SnapshotStubMappingGenerator stubMappingGenerator, SnapshotStubMappingPostProcessor stubMappingPostProcessor) {
        List<Pair<ServeEvent, StubMapping>> stubMappings = serveEventsResult.stream().filter(serveEventFilters).map(serveEvent -> new Pair<ServeEvent, StubMapping>((ServeEvent)serveEvent, stubMappingGenerator.apply((ServeEvent)serveEvent))).collect(Collectors.toList());
        return stubMappingPostProcessor.process(stubMappings);
    }

    private SnapshotStubMappingPostProcessor getStubMappingPostProcessor(RecordSpec recordSpec) {
        SnapshotStubMappingTransformerRunner transformerRunner = new SnapshotStubMappingTransformerRunner(this.extensions.ofType(StubMappingTransformer.class).values(), recordSpec.getTransformers(), recordSpec.getTransformerParameters(), this.filesBlobStore);
        return new SnapshotStubMappingPostProcessor(recordSpec.shouldRecordRepeatsAsScenarios(), transformerRunner, recordSpec.getExtractBodyCriteria(), new SnapshotStubMappingBodyExtractor(this.filesBlobStore));
    }

    public RecordingStatus getStatus() {
        return this.stateStore.get().getStatus();
    }
}

