/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty12;

import wiremock.org.eclipse.jetty.server.Handler;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.ServerConnector;
import wiremock.org.eclipse.jetty.util.Callback;

public class HttpProxyDetectingHandler
extends Handler.Abstract {
    public static final String IS_HTTP_PROXY_REQUEST_ATTRIBUTE = "wiremock.isHttpProxyRequest";
    private final ServerConnector httpConnector;

    public HttpProxyDetectingHandler(ServerConnector httpConnector) {
        this.httpConnector = httpConnector;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        int httpPort = this.httpConnector.getLocalPort();
        if (httpPort != request.getHttpURI().getPort() && "http".equals(request.getHttpURI().getScheme())) {
            request.setAttribute(IS_HTTP_PROXY_REQUEST_ATTRIBUTE, true);
        }
        return false;
    }
}

