/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.Extension;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExtensionLoader {
    private ExtensionLoader() {
    }

    public static <T> Map<String, T> loadExtension(String ... classNames) {
        return ExtensionLoader.asMap(Arrays.stream(classNames).map(ExtensionLoader.toClasses()).map(ExtensionLoader.toExtensions()).collect(Collectors.toList()));
    }

    public static Map<String, Extension> load(String ... classNames) {
        return ExtensionLoader.loadExtension(classNames);
    }

    public static Map<String, Extension> asMap(List<Extension> extensions) {
        return extensions.stream().map(extension -> Map.entry(extension.getName(), extension)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SafeVarargs
    public static Map<String, Extension> load(Class<? extends Extension> ... classes) {
        return ExtensionLoader.asMap(Arrays.stream(classes).map(ExtensionLoader.toExtensions()).collect(Collectors.toList()));
    }

    private static Function<Class<? extends Extension>, Extension> toExtensions() {
        return extensionClass -> {
            try {
                return (Extension)extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                return Exceptions.throwUnchecked(e, Extension.class);
            }
        };
    }

    private static Function<String, Class<? extends Extension>> toClasses() {
        return className -> {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return Exceptions.throwUnchecked(e, Class.class);
            }
        };
    }

    public static <T extends Extension> Predicate<Map.Entry<String, Extension>> valueAssignableFrom(Class<T> extensionType) {
        return input -> extensionType.isAssignableFrom(((Extension)input.getValue()).getClass());
    }
}

