/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.LimitAndOffsetPaginator;
import com.github.tomakehurst.wiremock.admin.model.GetGlobalSettingsResult;
import com.github.tomakehurst.wiremock.admin.model.GetScenariosResult;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.ServeEventQuery;
import com.github.tomakehurst.wiremock.admin.model.SingleServedStubResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.extension.Extensions;
import com.github.tomakehurst.wiremock.extension.GlobalSettingsListener;
import com.github.tomakehurst.wiremock.extension.MappingsLoaderExtension;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformerV2;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseTransformerV2;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterV2;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.http.client.HttpClient;
import com.github.tomakehurst.wiremock.http.client.HttpClientFactory;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.Recorder;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.store.DefaultStores;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.stubbing.InMemoryScenarios;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StoreBackedStubMappings;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.DisabledRequestJournal;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.FindServeEventsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.NearMissCalculator;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.RequestJournalDisabledException;
import com.github.tomakehurst.wiremock.verification.StoreBackedRequestJournal;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import wiremock.com.jayway.jsonpath.JsonPathException;
import wiremock.com.jayway.jsonpath.spi.cache.CacheProvider;
import wiremock.com.jayway.jsonpath.spi.cache.NOOPCache;

public class WireMockApp
implements StubServer,
Admin {
    public static final String FILES_ROOT = "__files";
    public static final String ADMIN_CONTEXT_ROOT = "/__admin";
    public static final String MAPPINGS_ROOT = "mappings";
    private static final AtomicBoolean FACTORIES_LOADING_OPTIMIZED = new AtomicBoolean(false);
    private final Stores stores;
    private final Scenarios scenarios;
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;
    private final SettingsStore settingsStore;
    private final boolean browserProxyingEnabled;
    private final MappingsLoader defaultMappingsLoader;
    private final Container container;
    private final MappingsSaver mappingsSaver;
    private final NearMissCalculator nearMissCalculator;
    private final Recorder recorder;
    private final List<GlobalSettingsListener> globalSettingsListeners;
    private final Map<String, MappingsLoaderExtension> mappingsLoaderExtensions;
    private final Map<String, ServeEventListener> serveEventListeners;
    private Options options;
    private Extensions extensions;

    public WireMockApp(Options options, Container container) {
        if (!options.getDisableOptimizeXmlFactoriesLoading() && Boolean.FALSE.equals(FACTORIES_LOADING_OPTIMIZED.get())) {
            Xml.optimizeFactoriesLoading();
            FACTORIES_LOADING_OPTIMIZED.set(true);
        }
        try {
            CacheProvider.setCache(new NOOPCache());
        }
        catch (JsonPathException jsonPathException) {
            // empty catch block
        }
        this.options = options;
        this.stores = options.getStores();
        this.stores.start();
        this.browserProxyingEnabled = options.browserProxySettings().enabled();
        this.defaultMappingsLoader = options.mappingsLoader();
        this.mappingsSaver = options.mappingsSaver();
        this.settingsStore = this.stores.getSettingsStore();
        this.extensions = new Extensions(options.getDeclaredExtensions(), this, options, this.stores, options.filesRoot().child(FILES_ROOT));
        this.extensions.load();
        Map<String, RequestMatcherExtension> customMatchers = this.extensions.ofType(RequestMatcherExtension.class);
        this.serveEventListeners = this.extensions.ofType(ServeEventListener.class);
        this.requestJournal = options.requestJournalDisabled() ? new DisabledRequestJournal() : new StoreBackedRequestJournal(options.maxRequestJournalEntries().orElse(null), customMatchers, this.stores.getRequestJournalStore());
        this.scenarios = new InMemoryScenarios(this.stores.getScenariosStore());
        this.stubMappings = new StoreBackedStubMappings(this.stores.getStubStore(), this.scenarios, customMatchers, this.extensions.ofType(ResponseDefinitionTransformer.class), this.extensions.ofType(ResponseDefinitionTransformerV2.class), this.stores.getFilesBlobStore(), List.copyOf(this.extensions.ofType(StubLifecycleListener.class).values()), this.serveEventListeners);
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal, this.scenarios, customMatchers);
        this.recorder = new Recorder(this, this.extensions, this.stores.getFilesBlobStore(), this.stores.getRecorderStateStore());
        this.globalSettingsListeners = List.copyOf(this.extensions.ofType(GlobalSettingsListener.class).values());
        this.mappingsLoaderExtensions = this.extensions.ofType(MappingsLoaderExtension.class);
        this.container = container;
        this.extensions.startAll();
        this.loadDefaultMappings();
    }

    public WireMockApp(boolean browserProxyingEnabled, MappingsLoader defaultMappingsLoader, Map<String, MappingsLoaderExtension> mappingsLoaderExtensions, MappingsSaver mappingsSaver, boolean requestJournalDisabled, Integer maxRequestJournalEntries, Map<String, ResponseDefinitionTransformer> transformers, Map<String, ResponseDefinitionTransformerV2> v2transformers, Map<String, RequestMatcherExtension> requestMatchers, FileSource rootFileSource, Container container) {
        this.stores = new DefaultStores(rootFileSource);
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.defaultMappingsLoader = defaultMappingsLoader;
        this.mappingsLoaderExtensions = mappingsLoaderExtensions;
        this.mappingsSaver = mappingsSaver;
        this.settingsStore = this.stores.getSettingsStore();
        this.requestJournal = requestJournalDisabled ? new DisabledRequestJournal() : new StoreBackedRequestJournal(maxRequestJournalEntries, requestMatchers, this.stores.getRequestJournalStore());
        this.scenarios = new InMemoryScenarios(this.stores.getScenariosStore());
        this.serveEventListeners = Collections.emptyMap();
        this.stubMappings = new StoreBackedStubMappings(this.stores.getStubStore(), this.scenarios, requestMatchers, transformers, v2transformers, this.stores.getFilesBlobStore(), Collections.emptyList(), this.serveEventListeners);
        this.container = container;
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal, this.scenarios, requestMatchers);
        this.recorder = new Recorder(this, this.extensions, this.stores.getFilesBlobStore(), this.stores.getRecorderStateStore());
        this.globalSettingsListeners = Collections.emptyList();
        this.loadDefaultMappings();
    }

    public AdminRequestHandler buildAdminRequestHandler() {
        AdminRoutes adminRoutes = AdminRoutes.forServer(this.extensions.ofType(AdminApiExtension.class).values(), this.stores);
        return new AdminRequestHandler(adminRoutes, this, new BasicResponseRenderer(), this.options.getAdminAuthenticator(), this.options.getHttpsRequiredForAdminApi(), this.getAdminRequestFilters(), this.getV2AdminRequestFilters(), this.options.getDataTruncationSettings());
    }

    public StubRequestHandler buildStubRequestHandler() {
        Map<String, PostServeAction> postServeActions = this.extensions.ofType(PostServeAction.class);
        BrowserProxySettings browserProxySettings = this.options.browserProxySettings();
        HttpClientFactory httpClientFactory = this.extensions.ofType(HttpClientFactory.class).values().stream().findFirst().orElse(this.options.httpClientFactory());
        HttpClient reverseProxyClient = httpClientFactory.buildHttpClient(this.options, true, Collections.emptyList(), true);
        HttpClient forwardProxyClient = httpClientFactory.buildHttpClient(this.options, browserProxySettings.trustAllProxyTargets(), browserProxySettings.trustAllProxyTargets() ? Collections.emptyList() : browserProxySettings.trustedProxyTargets(), false);
        return new StubRequestHandler(this, new StubResponseRenderer(this.options.getStores().getFilesBlobStore(), this.settingsStore, new ProxyResponseRenderer(this.options.shouldPreserveHostHeader(), this.options.proxyHostHeader(), this.settingsStore, this.options.getStubCorsEnabled(), this.options.getSupportedProxyEncodings(), reverseProxyClient, forwardProxyClient), List.copyOf(this.extensions.ofType(ResponseTransformer.class).values()), List.copyOf(this.extensions.ofType(ResponseTransformerV2.class).values())), this, postServeActions, this.serveEventListeners, this.requestJournal, this.getStubRequestFilters(), this.getV2StubRequestFilters(), this.options.getStubRequestLoggingDisabled(), this.options.getDataTruncationSettings(), this.options.getNotMatchedRendererFactory().apply(this.extensions));
    }

    private List<RequestFilter> getAdminRequestFilters() {
        return this.extensions.ofType(RequestFilter.class).values().stream().filter(RequestFilter::applyToAdmin).collect(Collectors.toList());
    }

    private List<RequestFilterV2> getV2AdminRequestFilters() {
        return this.extensions.ofType(RequestFilterV2.class).values().stream().filter(RequestFilterV2::applyToAdmin).collect(Collectors.toList());
    }

    private List<RequestFilter> getStubRequestFilters() {
        return this.extensions.ofType(RequestFilter.class).values().stream().filter(RequestFilter::applyToStubs).collect(Collectors.toList());
    }

    private List<RequestFilterV2> getV2StubRequestFilters() {
        return this.extensions.ofType(RequestFilterV2.class).values().stream().filter(RequestFilterV2::applyToStubs).collect(Collectors.toList());
    }

    private void loadDefaultMappings() {
        this.loadMappingsUsing(this.defaultMappingsLoader);
        if (this.mappingsLoaderExtensions != null) {
            this.mappingsLoaderExtensions.values().forEach(e -> this.loadMappingsUsing((MappingsLoader)e));
        }
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        mappingsLoader.loadMappingsInto(this.stubMappings);
    }

    @Override
    public ServeEvent serveStubFor(ServeEvent initialServeEvent) {
        ServeEvent serveEvent = this.stubMappings.serveFor(initialServeEvent);
        if (serveEvent.isNoExactMatch() && this.browserProxyingEnabled && serveEvent.getRequest().isBrowserProxyRequest() && this.getGlobalSettings().getSettings().getProxyPassThrough()) {
            return ServeEvent.ofUnmatched(serveEvent.getRequest(), ResponseDefinition.browserProxy(serveEvent.getRequest()));
        }
        return serveEvent;
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        this.addStubMapping(stubMapping, true);
    }

    private void addStubMapping(StubMapping stubMapping, boolean persistNow) {
        if (stubMapping.getId() == null) {
            stubMapping.setId(UUID.randomUUID());
        }
        this.stubMappings.addMapping(stubMapping);
        if (persistNow && stubMapping.shouldBePersisted()) {
            this.mappingsSaver.save(stubMapping);
        }
    }

    @Override
    public void removeStubMapping(StubMapping stubMapping) {
        this.removeStubMapping(stubMapping, true);
    }

    private StubMapping removeStubMapping(StubMapping stubMapping, boolean persistNow) {
        StubMapping matchedStub = this.findStubMatching(stubMapping);
        if (matchedStub == null) {
            return null;
        }
        this.stubMappings.removeMapping(matchedStub);
        if (persistNow && matchedStub.shouldBePersisted()) {
            this.mappingsSaver.remove(matchedStub.getId());
        }
        return matchedStub;
    }

    private StubMapping findStubMatching(StubMapping stubMapping) {
        return this.stubMappings.get(stubMapping.getId()).orElseGet(() -> this.stubMappings.getAll().stream().filter(stub -> stub.getRequest().equals(stubMapping.getRequest())).findFirst().orElse(null));
    }

    @Override
    public void removeStubMapping(UUID id) {
        this.stubMappings.get(id).ifPresent(this::removeStubMapping);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.editStubMapping(stubMapping, true);
    }

    private void editStubMapping(StubMapping stubMapping, boolean persistNow) {
        this.stubMappings.editMapping(stubMapping);
        if (persistNow && stubMapping.shouldBePersisted()) {
            this.mappingsSaver.save(stubMapping);
        }
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return new ListStubMappingsResult(LimitAndOffsetPaginator.none(this.stubMappings.getAll()));
    }

    @Override
    public SingleStubMappingResult getStubMapping(UUID id) {
        return SingleStubMappingResult.fromOptional(this.stubMappings.get(id));
    }

    @Override
    public void saveMappings() {
        for (StubMapping stubMapping : this.stubMappings.getAll()) {
            stubMapping.setPersistent(true);
            this.stubMappings.editMapping(stubMapping);
        }
        this.mappingsSaver.save(this.stubMappings.getAll());
    }

    @Override
    public void resetAll() {
        this.resetToDefaultMappings();
    }

    @Override
    public void resetRequests() {
        this.requestJournal.reset();
    }

    @Override
    public void resetToDefaultMappings() {
        this.stubMappings.reset();
        this.resetRequests();
        this.loadDefaultMappings();
    }

    @Override
    public void resetScenarios() {
        this.stubMappings.resetScenarios();
    }

    @Override
    public void resetMappings() {
        this.mappingsSaver.removeAll();
        this.stubMappings.reset();
    }

    @Override
    public GetServeEventsResult getServeEvents() {
        return this.getServeEvents(ServeEventQuery.ALL);
    }

    @Override
    public GetServeEventsResult getServeEvents(ServeEventQuery query) {
        try {
            List<ServeEvent> serveEvents = query.filter(this.requestJournal.getAllServeEvents());
            return GetServeEventsResult.requestJournalEnabled(LimitAndOffsetPaginator.none(serveEvents));
        }
        catch (RequestJournalDisabledException e) {
            return GetServeEventsResult.requestJournalDisabled(LimitAndOffsetPaginator.none(this.requestJournal.getAllServeEvents()));
        }
    }

    @Override
    public SingleServedStubResult getServedStub(UUID id) {
        return SingleServedStubResult.fromOptional(this.requestJournal.getServeEvent(id));
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        try {
            return VerificationResult.withCount(this.requestJournal.countRequestsMatching(requestPattern));
        }
        catch (RequestJournalDisabledException e) {
            return VerificationResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        try {
            List<LoggedRequest> requests = this.requestJournal.getRequestsMatching(requestPattern);
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        try {
            List<LoggedRequest> requests = this.requestJournal.getAllServeEvents().stream().filter(ServeEvent::isNoExactMatch).map(ServeEvent::getRequest).collect(Collectors.toList());
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public void removeServeEvent(UUID eventId) {
        this.requestJournal.removeEvent(eventId);
    }

    @Override
    public FindServeEventsResult removeServeEventsMatching(RequestPattern requestPattern) {
        return new FindServeEventsResult(this.requestJournal.removeEventsMatching(requestPattern));
    }

    @Override
    public FindServeEventsResult removeServeEventsForStubsMatchingMetadata(StringValuePattern metadataPattern) {
        return new FindServeEventsResult(this.requestJournal.removeServeEventsForStubsMatchingMetadata(metadataPattern));
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        ArrayList<NearMiss> nearMisses = new ArrayList<NearMiss>();
        List unmatchedServeEvents = this.requestJournal.getAllServeEvents().stream().filter(ServeEvent::isNoExactMatch).collect(Collectors.toList());
        for (ServeEvent serveEvent : unmatchedServeEvents) {
            nearMisses.addAll(this.nearMissCalculator.findNearestTo(serveEvent.getRequest()));
        }
        return new FindNearMissesResult(nearMisses);
    }

    @Override
    public GetScenariosResult getAllScenarios() {
        return new GetScenariosResult(this.stubMappings.getAllScenarios());
    }

    @Override
    public void resetScenario(String name) {
        this.scenarios.resetSingle(name);
    }

    @Override
    public void setScenarioState(String name, String state) {
        this.scenarios.setSingle(name, state);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(loggedRequest));
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(requestPattern));
    }

    @Override
    public GetGlobalSettingsResult getGlobalSettings() {
        return new GetGlobalSettingsResult(this.settingsStore.get());
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        GlobalSettings oldSettings = this.settingsStore.get();
        for (GlobalSettingsListener listener : this.globalSettingsListeners) {
            listener.beforeGlobalSettingsUpdated(oldSettings, newSettings);
        }
        this.settingsStore.set(newSettings);
        for (GlobalSettingsListener listener : this.globalSettingsListeners) {
            listener.afterGlobalSettingsUpdated(oldSettings, newSettings);
        }
    }

    public int port() {
        return this.container.port();
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void shutdownServer() {
        this.extensions.stopAll();
        this.stores.stop();
        this.container.shutdown();
    }

    @Override
    public SnapshotRecordResult snapshotRecord() {
        return this.snapshotRecord(RecordSpec.DEFAULTS);
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpecBuilder spec) {
        return this.snapshotRecord(spec.build());
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpec recordSpec) {
        return this.recorder.takeSnapshot(this.getServeEvents().getServeEvents(), recordSpec);
    }

    @Override
    public void startRecording(String targetBaseUrl) {
        this.recorder.startRecording(RecordSpec.forBaseUrl(targetBaseUrl));
    }

    @Override
    public void startRecording(RecordSpec recordSpec) {
        this.recorder.startRecording(recordSpec);
    }

    @Override
    public void startRecording(RecordSpecBuilder recordSpec) {
        this.recorder.startRecording(recordSpec.build());
    }

    @Override
    public SnapshotRecordResult stopRecording() {
        return this.recorder.stopRecording();
    }

    @Override
    public RecordingStatusResult getRecordingStatus() {
        return new RecordingStatusResult(this.recorder.getStatus().name());
    }

    private Set<UUID> findMatchedStubIds() {
        return this.requestJournal.getAllServeEvents().stream().filter(event -> event.getStubMapping() != null).map(event -> event.getStubMapping().getId()).collect(Collectors.toSet());
    }

    @Override
    public ListStubMappingsResult findUnmatchedStubs() {
        Set<UUID> servedStubIds = this.findMatchedStubIds();
        List foundMappings = this.stubMappings.getAll().stream().filter(stub -> !servedStubIds.contains(stub.getId())).collect(Collectors.toList());
        return new ListStubMappingsResult(LimitAndOffsetPaginator.none(foundMappings));
    }

    @Override
    public ListStubMappingsResult findAllStubsByMetadata(StringValuePattern pattern) {
        return new ListStubMappingsResult(LimitAndOffsetPaginator.none(this.stubMappings.findByMetadata(pattern)));
    }

    @Override
    public void removeStubsByMetadata(StringValuePattern pattern) {
        this.removeStubMappings(this.stubMappings.findByMetadata(pattern));
    }

    @Override
    public void importStubs(StubImport stubImport) {
        List<StubMapping> mappings = stubImport.getMappings();
        StubImport.Options importOptions = ParameterUtils.getFirstNonNull(stubImport.getImportOptions(), StubImport.Options.DEFAULTS);
        ArrayList<StubMapping> mappingsToSave = new ArrayList<StubMapping>();
        for (int i2 = mappings.size() - 1; i2 >= 0; --i2) {
            StubMapping mapping = mappings.get(i2);
            if (mapping.getId() != null && this.getStubMapping(mapping.getId()).isPresent()) {
                if (importOptions.getDuplicatePolicy() != StubImport.Options.DuplicatePolicy.OVERWRITE) continue;
                this.editStubMapping(mapping, false);
                if (!mapping.shouldBePersisted()) continue;
                mappingsToSave.add(mapping);
                continue;
            }
            this.addStubMapping(mapping, false);
            if (!mapping.shouldBePersisted()) continue;
            mappingsToSave.add(mapping);
        }
        if (importOptions.getDeleteAllNotInImport().booleanValue()) {
            List ids = mappings.stream().map(StubMapping::getId).collect(Collectors.toList());
            for (StubMapping mapping : this.listAllStubMappings().getMappings()) {
                if (ids.contains(mapping.getId())) continue;
                this.removeStubMapping(mapping, false);
            }
            this.mappingsSaver.setAll(mappingsToSave);
        } else if (!mappingsToSave.isEmpty()) {
            this.mappingsSaver.save(mappingsToSave);
        }
    }

    @Override
    public void removeStubMappings(List<StubMapping> stubMappings) {
        ArrayList<UUID> mappingsToDelete = new ArrayList<UUID>();
        for (StubMapping mapping : stubMappings) {
            StubMapping removed = this.removeStubMapping(mapping, false);
            if (removed == null || !removed.shouldBePersisted()) continue;
            mappingsToDelete.add(removed.getId());
        }
        if (!mappingsToDelete.isEmpty()) {
            this.mappingsSaver.remove(mappingsToDelete);
        }
    }

    public Set<String> getLoadedExtensionNames() {
        return this.extensions.getAllExtensionNames();
    }
}

