/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ListOrSingleSerialiser;
import com.github.tomakehurst.wiremock.common.ListOrStringDeserialiser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=ListOrSingleSerialiser.class)
@JsonDeserialize(using=ListOrStringDeserialiser.class)
public class ListOrSingle<T>
extends ArrayList<T> {
    public ListOrSingle(Collection<? extends T> c) {
        super(c);
    }

    public ListOrSingle(T ... items) {
        this((Collection<T>)Arrays.asList(items));
    }

    @Override
    public String toString() {
        return this.size() > 0 ? this.get(0).toString() : "";
    }

    public static <T> ListOrSingle<T> of(T ... items) {
        return new ListOrSingle<T>(items);
    }

    public static <T> ListOrSingle<T> of(List<T> items) {
        return new ListOrSingle<T>(items);
    }

    @Override
    public T getFirst() {
        return this.get(0);
    }

    @Override
    public T getLast() {
        return this.get(this.size() - 1);
    }

    @Override
    public T get(int index) {
        if (index < 0) {
            index = this.size() - 1 + index;
        }
        return (T)super.get(index);
    }

    public boolean isSingle() {
        return this.size() == 1;
    }
}

