/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.DefaultExternalizerProviders;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DynamicExternalizerObjectTable
extends ExternalizerObjectTable {
    public DynamicExternalizerObjectTable(ClassLoader loader) {
        this(List.of(loader));
    }

    public DynamicExternalizerObjectTable(List<ClassLoader> loaders) {
        this(List.of(), loaders);
    }

    public DynamicExternalizerObjectTable(List<Externalizer<?>> externalizers, List<ClassLoader> loaders) {
        super(DynamicExternalizerObjectTable.loadExternalizers(externalizers, loaders));
    }

    private static List<Externalizer<?>> loadExternalizers(List<Externalizer<?>> externalizers, final List<ClassLoader> loaders) {
        List loadedExternalizers = (List)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<List<Externalizer<?>>>(){

            @Override
            public List<Externalizer<?>> run() {
                LinkedList externalizers = new LinkedList();
                for (ClassLoader loader : loaders) {
                    for (Externalizer externalizer : ServiceLoader.load(Externalizer.class, loader)) {
                        externalizers.add(externalizer);
                    }
                }
                return externalizers;
            }
        });
        EnumSet<DefaultExternalizerProviders> providers = EnumSet.allOf(DefaultExternalizerProviders.class);
        int size = loadedExternalizers.size();
        for (DefaultExternalizerProviders provider : providers) {
            size += provider.get().size();
        }
        ArrayList result = new ArrayList(size);
        result.addAll(externalizers);
        for (DefaultExternalizerProviders provider : providers) {
            result.addAll((Collection<Externalizer<?>>)provider.get());
        }
        result.addAll(loadedExternalizers);
        return result;
    }
}

