/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.wildfly.swarm.plugin.BootstrapMarker;
import org.wildfly.swarm.plugin.Jandexer;
import org.wildfly.swarm.plugin.ModuleFiller;
import org.wildfly.swarm.plugin.ProvidedDependenciesGenerator;
import org.xml.sax.SAXException;

@Mojo(name="process", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ProcessMojo
extends AbstractMojo {
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Inject
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeBootstrapMarker();
        this.executeProvidedDependenciesGenerator();
        this.executeModuleFiller();
        this.executeJandexer();
    }

    protected void executeBootstrapMarker() throws MojoExecutionException {
        BootstrapMarker bootstrapMarker = new BootstrapMarker(this.getLog(), this.project);
        try {
            bootstrapMarker.execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute bootstrap marker", (Exception)e);
        }
    }

    protected void executeProvidedDependenciesGenerator() throws MojoExecutionException {
        ProvidedDependenciesGenerator generator = new ProvidedDependenciesGenerator(this.getLog(), this.project);
        try {
            generator.execute();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new MojoExecutionException("Unable to execute provided dependencies", e);
        }
    }

    protected void executeModuleFiller() throws MojoExecutionException {
        ModuleFiller moduleFiller = new ModuleFiller(this.getLog(), this.repositorySystemSession, this.resolver, this.project);
        try {
            moduleFiller.execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute module filler", (Exception)e);
        }
    }

    protected void executeJandexer() throws MojoExecutionException {
        Jandexer jandexer = new Jandexer(this.getLog(), new File(this.project.getBuild().getOutputDirectory()));
        try {
            jandexer.execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute jandexer", (Exception)e);
        }
    }
}

