/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.wildfly.swarm.plugin.FileSet;

public class Jandexer {
    public static final String INDEX_NAME = "swarm-jandex.idx";
    private Log log;
    private File classesDir;

    public Jandexer(Log log, File classesDir) {
        this.log = log;
        this.classesDir = classesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws IOException {
        String[] files;
        List<String> excludes;
        List<String> includes;
        FileSet fs = new FileSet();
        fs.setDirectory(this.classesDir);
        fs.setIncludes(Collections.singletonList("**/*.class"));
        Indexer indexer = new Indexer();
        File dir = fs.getDirectory();
        if (!dir.exists()) {
            return;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        if (fs.isUseDefaultExcludes()) {
            scanner.addDefaultExcludes();
        }
        if ((includes = fs.getIncludes()) != null) {
            scanner.setIncludes(includes.toArray(new String[0]));
        }
        if ((excludes = fs.getExcludes()) != null) {
            scanner.setExcludes(excludes.toArray(new String[0]));
        }
        scanner.scan();
        for (String file : files = scanner.getIncludedFiles()) {
            if (!file.endsWith(".class")) continue;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(new File(dir, file));
                ClassInfo classInfo = indexer.index((InputStream)fis);
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
            IOUtil.close((InputStream)fis);
        }
        File idx = new File(dir, "META-INF/swarm-jandex.idx");
        idx.getParentFile().mkdirs();
        FileOutputStream indexOut = null;
        try {
            indexOut = new FileOutputStream(idx);
            IndexWriter writer = new IndexWriter((OutputStream)indexOut);
            Index index = indexer.complete();
            writer.write(index);
        }
        catch (Throwable throwable) {
            IOUtil.close(indexOut);
            throw throwable;
        }
        IOUtil.close((OutputStream)indexOut);
    }
}

