/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystemSession;
import org.wildfly.swarm.plugin.AbstractExposedComponentsMojo;
import org.wildfly.swarm.plugin.Fraction;

@Mojo(name="fraction-list", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class FractionListMojo
extends AbstractExposedComponentsMojo {
    private static final String FRACTION_TAGS_PROPERTY_NAME = "swarm.fraction.tags";
    private static final String FRACTION_INTERNAL_PROPERTY_NAME = "swarm.fraction.internal";
    @Inject
    ProjectBuilder projectBuilder;
    private Set<String> testedGAVs = new HashSet<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Dependency> fractionsDependencies = this.bomDependencies().stream().sorted((l, r) -> {
            int result = l.getGroupId().compareTo(r.getGroupId());
            if (result != 0) {
                return result;
            }
            return l.getArtifactId().compareTo(r.getArtifactId());
        }).filter(this::isFraction).collect(Collectors.toList());
        TreeMap<String, Fraction> fractions = new TreeMap<String, Fraction>();
        fractionsDependencies.forEach(d -> fractions.put(d.getGroupId() + ":" + d.getArtifactId(), new Fraction(d.getGroupId(), d.getArtifactId(), d.getVersion())));
        fractionsDependencies.forEach(dependency -> {
            Fraction current = (Fraction)fractions.get(dependency.getGroupId() + ":" + dependency.getArtifactId());
            try {
                MavenProject fractionProject = this.project((Dependency)dependency);
                current.setName(fractionProject.getName());
                current.setDescription(fractionProject.getDescription());
                Properties properties = fractionProject.getProperties();
                current.setTags(properties.getProperty(FRACTION_TAGS_PROPERTY_NAME, ""));
                current.setInternal(Boolean.parseBoolean(properties.getProperty(FRACTION_INTERNAL_PROPERTY_NAME)));
                Set deps = fractionProject.getArtifacts();
                for (Artifact each : deps) {
                    Fraction f = (Fraction)fractions.get(each.getGroupId() + ":" + each.getArtifactId());
                    if (f == null) continue;
                    current.addDependency(f);
                }
            }
            catch (ProjectBuildingException e) {
                e.printStackTrace();
            }
        });
        this.generateTxt(fractions);
        this.generateJSON(fractions);
        this.generateJavascript(fractions);
    }

    protected void generateTxt(Map<String, Fraction> fractions) {
        File outFile = new File(this.project.getBuild().getOutputDirectory(), "fraction-list.txt");
        outFile.getParentFile().mkdirs();
        try (FileWriter out = new FileWriter(outFile);){
            for (Fraction each : fractions.values()) {
                out.write(each.toString());
                out.write(" = ");
                out.write(each.getDependenciesString());
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "txt", "", (ArtifactHandler)new DefaultArtifactHandler("txt"));
        artifact.setFile(outFile);
        this.project.addAttachedArtifact((Artifact)artifact);
    }

    protected void generateJSON(Map<String, Fraction> fractions) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File outFile = new File(this.project.getBuild().getOutputDirectory(), "fraction-list.json");
        try {
            mapper.writeValue(outFile, fractions.values());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "json", "", (ArtifactHandler)new DefaultArtifactHandler("json"));
        artifact.setFile(outFile);
        this.project.addAttachedArtifact((Artifact)artifact);
    }

    protected void generateJavascript(Map<String, Fraction> fractions) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        File outFile = new File(this.project.getBuild().getOutputDirectory(), "fraction-list.js");
        try (FileWriter writer = new FileWriter(outFile);){
            writer.write("fractionList = ");
            writer.flush();
            mapper.writeValue((Writer)writer, fractions.values());
            writer.write(";");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "js", "", (ArtifactHandler)new DefaultArtifactHandler("js"));
        artifact.setFile(outFile);
        this.project.addAttachedArtifact((Artifact)artifact);
    }

    protected MavenProject project(Dependency dependency) throws ProjectBuildingException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setProcessPlugins(false);
        request.setSystemProperties(System.getProperties());
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        request.setRepositorySession((RepositorySystemSession)this.repositorySystemSession);
        request.setResolveDependencies(true);
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "compile", "", "", (ArtifactHandler)new DefaultArtifactHandler());
        MavenProject project = this.projectBuilder.build((Artifact)artifact, (ProjectBuildingRequest)request).getProject();
        return project;
    }

    protected boolean isFraction(Dependency dep) {
        return this.isFraction(dep, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isFraction(Dependency dep, boolean tryApi) {
        if (!dep.getType().equals("jar")) {
            return false;
        }
        if (!dep.getGroupId().equals("org.wildfly.swarm")) {
            return false;
        }
        String groupId = dep.getGroupId();
        String artifactId = dep.getArtifactId() + (tryApi ? "-api" : "");
        if (this.testedGAVs.contains(groupId + ":" + artifactId)) {
            return false;
        }
        this.testedGAVs.add(groupId + ":" + artifactId);
        try {
            File file = this.resolveArtifact(groupId, artifactId, dep.getVersion(), "", "jar");
            if (file == null) return false;
            try (JarFile jar = new JarFile(file);){
                ZipEntry bootstrap = jar.getEntry("wildfly-swarm-bootstrap.conf");
                if (bootstrap != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            if (tryApi) return false;
            return this.isFraction(dep, true);
        }
        catch (IOException | AbstractExposedComponentsMojo.ArtifactResolutionRuntimeException exception) {
            // empty catch block
        }
        return false;
    }
}

