/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class Fraction {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private String name;
    private String description;
    private String tags;
    private boolean internal;
    private final Set<Fraction> dependencies = new HashSet<Fraction>();

    public Fraction(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addDependency(Fraction fraction) {
        this.dependencies.add(fraction);
    }

    @JsonIgnore
    public Set<Fraction> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        String artifactId = this.artifactId;
        if (artifactId.endsWith("-api")) {
            artifactId = artifactId.substring(0, artifactId.length() - 4);
        }
        return this.groupId + ":" + artifactId + ":" + this.version;
    }

    @JsonIgnore
    public String getDependenciesString() {
        return String.join((CharSequence)", ", this.dependencies.stream().map(e -> e.toString()).collect(Collectors.toList()));
    }
}

