/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.wildfly.swarm.plugin.ExposedComponent;

public class ExposedComponents {
    private final String name;
    private final String version;
    private final List<ExposedComponent> components;

    public static ExposedComponents parseDescriptor(String version, URL content) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            TypeFactory typeFactory = mapper.getTypeFactory();
            Map components = (Map)mapper.readValue(content, (JavaType)typeFactory.constructMapType(Map.class, typeFactory.constructType(String.class), (JavaType)typeFactory.constructCollectionType(List.class, ExposedComponent.class)));
            String moduleName = components.keySet().stream().findFirst().orElse(null);
            return new ExposedComponents(moduleName, version, (List)components.get(moduleName));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse descriptor", e);
        }
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public List<ExposedComponent> components() {
        return this.components;
    }

    private ExposedComponents(String name, String version, List<ExposedComponent> components) {
        this.name = name;
        this.version = version;
        this.components = components;
    }
}

