/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.plugin.AbstractExposedComponentsMojo;
import org.wildfly.swarm.plugin.ExposedComponents;

@Mojo(name="prep-doc-source", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class DocPrepMojo
extends AbstractExposedComponentsMojo {
    @Parameter
    private File sourceOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.sourceOutputDir.mkdirs();
        try {
            for (ExposedComponents ecs : this.resolvedComponents()) {
                File srcDir = new File(this.sourceOutputDir, ecs.name());
                srcDir.mkdirs();
                ecs.components().stream().filter(d -> d.doc() != null).forEach(d -> ((ExplodedExporter)((JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)this.resolveArtifact("org.wildfly.swarm", d.doc(), ecs.version(), "sources", "jar"))).as(ExplodedExporter.class)).exportExploded(this.sourceOutputDir, ecs.name()));
                if (srcDir.listFiles().length <= 0) continue;
                Files.write(Paths.get(srcDir.getAbsolutePath(), "_version"), ecs.version().getBytes(), new OpenOption[0]);
            }
        }
        catch (IOException | AbstractExposedComponentsMojo.ArtifactResolutionRuntimeException e) {
            throw new MojoFailureException("Failed to resolve sources artifact", (Throwable)e);
        }
    }
}

