/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.wildfly.swarm.plugin.BomBuilder;
import org.wildfly.swarm.plugin.ExposedComponents;

public abstract class AbstractExposedComponentsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(alias="remoteRepositories", defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Inject
    private ArtifactResolver resolver;
    @Parameter
    private List<String> modules = new ArrayList<String>();
    private Map<String, String> versions = new HashMap<String, String>();
    private List<ExposedComponents> components = new ArrayList<ExposedComponents>();

    protected static Proxy convertFromMavenProxy(org.apache.maven.settings.Proxy proxy) {
        if (proxy != null) {
            return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build());
        }
        return null;
    }

    protected File resolveArtifact(String group, String name, String version, String classifier, String type) throws ArtifactResolutionRuntimeException {
        List aetherRepos = this.remoteRepositories.stream().map(r -> this.buildRemoteRepository(r.getId(), r.getUrl(), r.getAuthentication())).collect(Collectors.toList());
        DefaultArtifact artifact = new DefaultArtifact(group, name, classifier, type, version);
        LocalArtifactResult localResult = this.repositorySystemSession.getLocalRepositoryManager().find((RepositorySystemSession)this.repositorySystemSession, new LocalArtifactRequest((Artifact)artifact, aetherRepos, null));
        File file = null;
        if (localResult.isAvailable()) {
            file = localResult.getFile();
        } else {
            ArtifactResult result;
            try {
                result = this.resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, new ArtifactRequest((Artifact)artifact, aetherRepos, null));
            }
            catch (ArtifactResolutionException e) {
                throw new ArtifactResolutionRuntimeException(String.format("%s:%s:%s:%s:%s", group, name, version, classifier, type), e);
            }
            if (result.isResolved()) {
                file = result.getArtifact().getFile();
            }
        }
        return file;
    }

    protected RemoteRepository buildRemoteRepository(String id, String url, Authentication auth) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
        if (auth != null && auth.getUsername() != null && auth.getPassword() != null) {
            builder.setAuthentication(new AuthenticationBuilder().addUsername(auth.getUsername()).addPassword(auth.getPassword()).build());
        }
        builder.setProxy(AbstractExposedComponentsMojo.convertFromMavenProxy(this.mavenSession.getSettings().getActiveProxy()));
        return builder.build();
    }

    protected Map<String, String> parsedModules() {
        if (this.versions.isEmpty()) {
            this.modules.forEach(c -> {
                String[] parts = c.split(":");
                this.versions.put(parts[0], parts[1]);
            });
        }
        return this.versions;
    }

    protected List<ExposedComponents> resolvedComponents() {
        if (this.components.isEmpty()) {
            this.parsedModules().forEach((k, v) -> this.components.add(this.resolveComponentDescriptor((String)k, (String)v)));
        }
        return this.components;
    }

    protected ExposedComponents resolveComponentDescriptor(String name, String version) {
        File descriptorFile = null;
        try {
            descriptorFile = this.resolveArtifact("org.wildfly.swarm", name, version, "exposed-components", "json");
        }
        catch (ArtifactResolutionRuntimeException e) {
            throw new RuntimeException(String.format("Failed to locate exposed-components.json for %s:%s", name, version), e.getCause());
        }
        try {
            return descriptorFile != null ? ExposedComponents.parseDescriptor(version, descriptorFile.toURI().toURL()) : null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Failed to read exposed-components.json for %s:%s", name, version), e);
        }
    }

    protected Dependency gavToDependency(String gav) {
        String[] parts = gav.split(":");
        Dependency dep = new Dependency();
        dep.setGroupId(parts[0]);
        dep.setArtifactId(parts[1]);
        dep.setVersion(parts[2]);
        return dep;
    }

    protected List<Dependency> bomDependencies() {
        return BomBuilder.dependenciesList(this.resolvedComponents()).stream().map(this::gavToDependency).collect(Collectors.toList());
    }

    static class ArtifactResolutionRuntimeException
    extends RuntimeException {
        public ArtifactResolutionRuntimeException(String gav, ArtifactResolutionException cause) {
            super(String.format("%s for: %s", cause.getMessage(), gav), (Throwable)cause);
        }
    }
}

