/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.repository;

import org.wildfly.plugin.repository.ArtifactName;
import org.wildfly.plugin.repository.Runtimes;

public class ArtifactNameBuilder {
    public static final String WILDFLY_GROUP_ID = "org.wildfly";
    public static final String WILDFLY_ARTIFACT_ID = "wildfly-dist";
    public static final String WILDFLY_PACKAGING = "zip";
    private final String artifact;
    private String groupId;
    private String artifactId;
    private String classifier;
    private String packaging;
    private String version;

    private ArtifactNameBuilder(String artifact) {
        this.artifact = artifact;
    }

    public static ArtifactNameBuilder of(String artifact) {
        return new ArtifactNameBuilder(artifact);
    }

    public static ArtifactNameBuilder forRuntime(String artifact) {
        return new ArtifactNameBuilder(artifact){

            @Override
            public ArtifactName build() {
                String version;
                String packaging;
                String artifactId;
                ArtifactName delegate = super.build();
                String groupId = delegate.getGroupId();
                if (groupId == null) {
                    groupId = ArtifactNameBuilder.WILDFLY_GROUP_ID;
                }
                if ((artifactId = delegate.getArtifactId()) == null) {
                    artifactId = ArtifactNameBuilder.WILDFLY_ARTIFACT_ID;
                }
                if ((packaging = delegate.getPackaging()) == null) {
                    packaging = ArtifactNameBuilder.WILDFLY_PACKAGING;
                }
                if ((version = delegate.getVersion()) == null) {
                    version = Runtimes.getLatestFinal(groupId, artifactId);
                }
                return new ArtifactNameImpl(groupId, artifactId, delegate.getClassifier(), packaging, version);
            }
        };
    }

    public ArtifactNameBuilder setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public ArtifactNameBuilder setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public ArtifactNameBuilder setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public ArtifactNameBuilder setPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public ArtifactNameBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public ArtifactName build() {
        String groupId = this.groupId;
        String artifactId = this.artifactId;
        String classifier = this.classifier;
        String packaging = this.packaging;
        String version = this.version;
        if (this.artifact != null && !this.artifact.isEmpty()) {
            String[] artifactSegments = this.artifact.split(":");
            switch (artifactSegments.length) {
                case 5: {
                    String value = artifactSegments[4].trim();
                    if (!value.isEmpty()) {
                        classifier = value;
                    }
                }
                case 4: {
                    String value = artifactSegments[3].trim();
                    if (!value.isEmpty()) {
                        packaging = value;
                    }
                }
                case 3: {
                    String value = artifactSegments[2].trim();
                    if (!value.isEmpty()) {
                        version = value;
                    }
                }
                case 2: {
                    String value = artifactSegments[1].trim();
                    if (!value.isEmpty()) {
                        artifactId = value;
                    }
                }
                case 1: {
                    String value = artifactSegments[0].trim();
                    if (value.isEmpty()) break;
                    groupId = value;
                }
            }
        }
        return new ArtifactNameImpl(groupId, artifactId, classifier, packaging, version);
    }

    private static class ArtifactNameImpl
    implements ArtifactName {
        private final String groupId;
        private final String artifactId;
        private final String classifier;
        private final String packaging;
        private final String version;

        private ArtifactNameImpl(String groupId, String artifactId, String classifier, String packaging, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
            this.packaging = packaging;
            this.version = version;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public String getClassifier() {
            return this.classifier;
        }

        @Override
        public String getPackaging() {
            return this.packaging;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        public String toString() {
            StringBuilder result = new StringBuilder().append("ArtifactName(").append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version).append(':');
            if (this.packaging != null) {
                result.append(this.packaging);
            }
            result.append(':');
            if (this.classifier != null) {
                result.append(this.classifier);
            }
            return result.append(')').toString();
        }
    }
}

