/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.wildfly.plugin.server.Server;

final class SecurityActions {
    SecurityActions() {
    }

    private static void respawnCurrentClassLoader() {
        ClassLoader tccl = SecurityActions.getCurrentClassLoader();
        if (tccl instanceof ClassRealm) {
            ClassRealm classRealm = (ClassRealm)tccl;
            ClassLoader newParent = SecurityActions.createNewClassLoader(classRealm);
            classRealm.setParentClassLoader(newParent);
        }
    }

    static void registerShutdown(final Server server) {
        Thread hook = new Thread(new Runnable(){

            @Override
            public void run() {
                SecurityActions.respawnCurrentClassLoader();
                server.stop();
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        hook.setDaemon(true);
        SecurityActions.addShutdownHook(hook);
    }

    static void addShutdownHook(final Thread hook) {
        if (System.getSecurityManager() == null) {
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        }
    }

    static String getEnvironmentVariable(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getenv(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(key);
            }
        });
    }

    static ClassLoader getCurrentClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static ClassLoader createNewClassLoader(final ClassRealm classRealm) {
        ClassLoader result = System.getSecurityManager() == null ? new URLClassLoader(classRealm.getURLs(), classRealm.getParentClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                Class<?> c = classRealm.loadClassFromSelf(name);
                return c != null ? c : super.loadClass(name, resolve);
            }
        } : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new URLClassLoader(classRealm.getURLs(), classRealm.getParentClassLoader()){

                    @Override
                    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        Class<?> c = classRealm.loadClassFromSelf(name);
                        return c != null ? c : super.loadClass(name, resolve);
                    }
                };
            }
        });
        return result;
    }
}

