/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.DeploymentFailureException;
import org.wildfly.plugin.common.Files;
import org.wildfly.plugin.common.ServerOperations;
import org.wildfly.plugin.deployment.DeployMojo;
import org.wildfly.plugin.deployment.standalone.StandaloneDeployment;
import org.wildfly.plugin.server.ArtifactResolver;
import org.wildfly.plugin.server.ModulesPath;
import org.wildfly.plugin.server.RuntimeVersions;
import org.wildfly.plugin.server.SecurityActions;
import org.wildfly.plugin.server.Server;
import org.wildfly.plugin.server.ServerInfo;
import org.wildfly.plugin.server.StandaloneServer;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunMojo
extends DeployMojo {
    public static final String WILDFLY_DIR = "wildfly-run";
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(property="wildfly.artifact")
    private String artifact;
    @Parameter(defaultValue="org.wildfly", property="wildfly.groupId")
    private String groupId;
    @Parameter(defaultValue="wildfly-dist", property="wildfly.artifactId")
    private String artifactId;
    @Parameter(property="wildfly.classifier")
    private String classifier;
    @Parameter(property="wildfly.packaging", defaultValue="zip")
    private String packaging;
    @Parameter(property="wildfly.version")
    private String version;
    @Parameter(alias="modules-path", property="wildfly.modulesPath")
    private ModulesPath modulesPath;
    @Parameter(alias="jvm-args", property="wildfly.jvmArgs", defaultValue="-Xms64m -Xmx512m -XX:MaxPermSize=256m -Djava.net.preferIPv4Stack=true")
    private String jvmArgs;
    @Parameter(alias="java-home", property="java.home")
    private String javaHome;
    @Parameter(alias="server-config", property="wildfly.serverConfig")
    private String serverConfig;
    @Parameter(alias="properties-file", property="wildfly.propertiesFile")
    private String propertiesFile;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.startupTimeout")
    private long startupTimeout;
    private RuntimeVersions runtimeVersions = new RuntimeVersions();

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        File deploymentFile = this.file();
        String deploymentName = deploymentFile.getName();
        File targetDir = deploymentFile.getParentFile();
        if (!deploymentFile.exists()) {
            throw new MojoExecutionException(String.format("The deployment '%s' could not be found.", deploymentFile.getAbsolutePath()));
        }
        File jbossHome = this.extractIfRequired(targetDir);
        if (!jbossHome.isDirectory()) {
            throw new MojoExecutionException(String.format("JBOSS_HOME '%s' is not a valid directory.", jbossHome));
        }
        String[] jvmArgs = this.jvmArgs == null ? null : this.jvmArgs.split("\\s+");
        String javaHome = this.javaHome == null ? SecurityActions.getEnvironmentVariable("JAVA_HOME") : this.javaHome;
        List<String> invalidPaths = this.modulesPath.validate();
        if (!invalidPaths.isEmpty()) {
            throw new MojoExecutionException("Invalid module path(s). " + invalidPaths);
        }
        ServerInfo serverInfo = ServerInfo.of(this, javaHome, jbossHome, this.modulesPath.get(), jvmArgs, this.serverConfig, this.propertiesFile, this.startupTimeout);
        log.info((CharSequence)String.format("JAVA_HOME=%s", javaHome));
        log.info((CharSequence)String.format("JBOSS_HOME=%s%n", jbossHome));
        StandaloneServer server = null;
        try {
            server = new StandaloneServer(serverInfo);
            SecurityActions.registerShutdown(server);
            log.info((CharSequence)"Server is starting up. Press CTRL + C to stop the server.");
            server.start();
            ((Server)server).checkServerState();
            if (((Server)server).isRunning()) {
                log.info((CharSequence)String.format("Deploying application '%s'%n", deploymentFile.getName()));
                ModelControllerClient client = ((Server)server).getClient();
                StandaloneDeployment deployment = StandaloneDeployment.create(client, deploymentFile, deploymentName, this.getType(), null, null);
                switch (this.executeDeployment(client, deployment)) {
                    case REQUIRES_RESTART: {
                        client.execute(ServerOperations.createOperation((String)"reload"));
                        break;
                    }
                }
            } else {
                throw new DeploymentFailureException("Cannot deploy to a server that is not running.");
            }
            while (((Server)server).isRunning()) {
                TimeUnit.SECONDS.sleep(1L);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("The server failed to start", e);
        }
        finally {
            if (server != null) {
                server.stop();
            }
        }
    }

    private File extractIfRequired(File buildDir) throws MojoFailureException, MojoExecutionException {
        if (this.jbossHome != null) {
            return new File(this.jbossHome);
        }
        File result = this.artifactResolver.resolve(this.project, this.createArtifact());
        File target = new File(buildDir, WILDFLY_DIR);
        if (target.exists()) {
            Files.deleteRecursively(target);
        }
        target.mkdirs();
        try {
            Files.unzip(result, target);
        }
        catch (IOException e) {
            throw new MojoFailureException("Artifact was not successfully extracted: " + result, (Throwable)e);
        }
        File[] files = target.listFiles();
        if (files == null || files.length != 1) {
            throw new MojoFailureException("Artifact was not successfully extracted: " + result);
        }
        return files[0];
    }

    @Override
    public String goal() {
        return "run";
    }

    private String createArtifact() throws MojoFailureException {
        String version;
        String groupId = this.groupId;
        String artifactId = this.artifactId;
        String classifier = this.classifier;
        String packaging = this.packaging;
        String string = version = this.version == null ? this.runtimeVersions.getLatestFinal(groupId, artifactId) : this.version;
        if (this.artifact != null) {
            String[] artifactParts = this.artifact.split(":");
            if (artifactParts.length == 0) {
                throw new MojoFailureException(String.format("Invalid artifact pattern: %s", this.artifact));
            }
            switch (artifactParts.length) {
                case 5: {
                    String value = artifactParts[4].trim();
                    if (!value.isEmpty()) {
                        classifier = value;
                    }
                }
                case 4: {
                    String value = artifactParts[3].trim();
                    if (!value.isEmpty()) {
                        packaging = value;
                    }
                }
                case 3: {
                    String value = artifactParts[2].trim();
                    if (!value.isEmpty()) {
                        version = value;
                    }
                }
                case 2: {
                    String value = artifactParts[1].trim();
                    if (!value.isEmpty()) {
                        artifactId = value;
                    }
                }
                case 1: {
                    String value = artifactParts[0].trim();
                    if (value.isEmpty()) break;
                    groupId = value;
                }
            }
        }
        if (groupId == null || artifactId == null || version == null) {
            throw new IllegalStateException("The groupId, artifactId and version parameters are required");
        }
        StringBuilder result = new StringBuilder();
        result.append(groupId).append(':').append(artifactId).append(':').append(version).append(':');
        if (packaging != null) {
            result.append(packaging);
        }
        result.append(':');
        if (classifier != null) {
            result.append(classifier);
        }
        return result.toString();
    }
}

