/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.wildfly.plugin.server.ArtifactResolver;

abstract class AbstractArtifactResolver<T>
implements ArtifactResolver {
    AbstractArtifactResolver() {
    }

    protected abstract T constructArtifact(String var1, String var2, String var3, String var4, String var5);

    protected T createArtifact(String artifact) {
        String groupId = null;
        String artifactId = null;
        String classifier = null;
        String packaging = null;
        String version = null;
        if (artifact != null) {
            String[] artifactParts = artifact.split(":");
            if (artifactParts.length == 0) {
                throw new IllegalArgumentException(String.format("Invalid artifact pattern: %s", artifact));
            }
            switch (artifactParts.length) {
                case 5: {
                    String value = artifactParts[4].trim();
                    if (!value.isEmpty()) {
                        classifier = value;
                    }
                }
                case 4: {
                    String value = artifactParts[3].trim();
                    if (!value.isEmpty()) {
                        packaging = value;
                    }
                }
                case 3: {
                    String value = artifactParts[2].trim();
                    if (!value.isEmpty()) {
                        version = value;
                    }
                }
                case 2: {
                    String value = artifactParts[1].trim();
                    if (!value.isEmpty()) {
                        artifactId = value;
                    }
                }
                case 1: {
                    String value = artifactParts[0].trim();
                    if (value.isEmpty()) break;
                    groupId = value;
                }
            }
        }
        return this.constructArtifact(groupId, artifactId, classifier, packaging, version);
    }

    static <T> T invoke(Object object, String method, Class<T> result) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method m = object.getClass().getMethod(method, new Class[0]);
        if (m == null) {
            throw new IllegalArgumentException(String.format("Method '%s' was not found on %s.", method, object.getClass()));
        }
        return result.cast(m.invoke(object, new Object[0]));
    }

    static boolean isUsingEclipseAether() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.aether.RepositorySystem");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

