/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.PrintStream;
import org.eclipse.transformer.action.impl.ChangesImpl;
import org.slf4j.Logger;

public class ClassChangesImpl
extends ChangesImpl {
    private String inputClassName;
    private String outputClassName;
    private String inputSuperName;
    private String outputSuperName;
    private int modifiedInterfaces;
    private int modifiedFields;
    private int modifiedMethods;
    private int modifiedAttributes;
    private int modifiedConstants;

    @Override
    public void clearChanges() {
        this.inputClassName = null;
        this.outputClassName = null;
        this.inputSuperName = null;
        this.outputSuperName = null;
        this.modifiedInterfaces = 0;
        this.modifiedFields = 0;
        this.modifiedMethods = 0;
        this.modifiedAttributes = 0;
        this.modifiedConstants = 0;
    }

    @Override
    public boolean hasNonResourceNameChanges() {
        return this.inputClassName != null && this.outputClassName != null && !this.inputClassName.equals(this.outputClassName) || this.inputSuperName != null && this.outputSuperName != null && !this.inputSuperName.equals(this.outputSuperName) || this.modifiedInterfaces > 0 || this.modifiedFields > 0 || this.modifiedMethods > 0 || this.modifiedAttributes > 0 || this.modifiedConstants > 0;
    }

    public String getInputClassName() {
        return this.inputClassName;
    }

    public void setInputClassName(String inputClassName) {
        this.inputClassName = inputClassName;
    }

    public String getOutputClassName() {
        return this.outputClassName;
    }

    public void setOutputClassName(String outputClassName) {
        this.outputClassName = outputClassName;
    }

    public String getInputSuperName() {
        return this.inputSuperName;
    }

    public void setInputSuperName(String inputSuperName) {
        this.inputSuperName = inputSuperName;
    }

    public String getOutputSuperName() {
        return this.outputSuperName;
    }

    public void setOutputSuperName(String outputSuperName) {
        this.outputSuperName = outputSuperName;
    }

    public int getModifiedInterfaces() {
        return this.modifiedInterfaces;
    }

    public void setModifiedInterfaces(int modifiedInterfaces) {
        this.modifiedInterfaces = modifiedInterfaces;
    }

    public void addModifiedInterface() {
        ++this.modifiedInterfaces;
    }

    public int getModifiedFields() {
        return this.modifiedFields;
    }

    public void setModifiedFields(int modifiedFields) {
        this.modifiedFields = modifiedFields;
    }

    public void addModifiedField() {
        ++this.modifiedFields;
    }

    public int getModifiedMethods() {
        return this.modifiedMethods;
    }

    public void setModifiedMethods(int modifiedMethods) {
        this.modifiedMethods = modifiedMethods;
    }

    public void addModifiedMethod() {
        ++this.modifiedMethods;
    }

    public int getModifiedAttributes() {
        return this.modifiedAttributes;
    }

    public void setModifiedAttributes(int modifiedAttributes) {
        this.modifiedAttributes = modifiedAttributes;
    }

    public void addModifiedAttribute() {
        ++this.modifiedAttributes;
    }

    public int getModifiedConstants() {
        return this.modifiedConstants;
    }

    public void setModifiedConstants(int modifiedConstants) {
        this.modifiedConstants = modifiedConstants;
    }

    public void addModifiedConstant() {
        ++this.modifiedConstants;
    }

    @Override
    public void displayVerbose(PrintStream printStream, String inputPath, String outputPath) {
        printStream.printf("Input name [ %s ] as [ %s ]\n", this.getInputResourceName(), inputPath);
        printStream.printf("Output name [ %s ] as [ %s ]\n", this.getOutputResourceName(), outputPath);
        printStream.printf("Class name [ %s ] [ %s ]\n", this.getInputClassName(), this.getOutputClassName());
        String useInputSuperName = this.getInputSuperName();
        if (useInputSuperName != null) {
            printStream.printf("Super class name [ %s ] [ %s ]\n", useInputSuperName, this.getOutputSuperName());
        }
        printStream.printf("Modified interfaces [ %s ]\n", this.getModifiedInterfaces());
        printStream.printf("Modified fields     [ %s ]\n", this.getModifiedFields());
        printStream.printf("Modified methods    [ %s ]\n", this.getModifiedMethods());
        printStream.printf("Modified constants  [ %s ]\n", this.getModifiedConstants());
    }

    @Override
    public void displayVerbose(Logger logger, String inputPath, String outputPath) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        logger.info("Input name [ {} ] as [ {} ]", (Object)this.getInputResourceName(), (Object)inputPath);
        logger.info("Output name [ {} ] as [ {} ]", (Object)this.getOutputResourceName(), (Object)outputPath);
        logger.info("Class name [ {} ] [ {} ]", (Object)this.getInputClassName(), (Object)this.getOutputClassName());
        String useInputSuperName = this.getInputSuperName();
        if (useInputSuperName != null) {
            logger.info("Super class name [ {} ] [ {} ]", (Object)useInputSuperName, (Object)this.getOutputSuperName());
        }
        logger.info("Modified interfaces [ {} ]", (Object)this.getModifiedInterfaces());
        logger.info("Modified fields     [ {} ]", (Object)this.getModifiedFields());
        logger.info("Modified methods    [ {} ]", (Object)this.getModifiedMethods());
        logger.info("Modified constants  [ {} ]", (Object)this.getModifiedConstants());
    }
}

